/*
 * Decompiled with CFR 0.152.
 */
package synapse.segmentation;

import synapse.BaseBot;
import synapse.Enemy;
import synapse.segmentation.Axis;

public class Orthogonality
extends Axis {
    private final int segments;

    public Orthogonality() {
        this(6);
    }

    public Orthogonality(int segments) {
        this.segments = segments;
    }

    @Override
    public double getMin() {
        return 0.0;
    }

    @Override
    public double getMax() {
        return 1.0;
    }

    @Override
    public int getNumSegments() {
        return this.segments;
    }

    @Override
    public double getAxisValue(Enemy e) {
        return Math.sin(e.heading - e.bearing);
    }

    @Override
    public double getAxisValue(BaseBot j) {
        return Math.sin(j.heading - j.target.bearing);
    }

    @Override
    public String toString() {
        return "Orthogonality";
    }
}

