/*
 * Decompiled with CFR 0.152.
 */
package ry;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Enumeration;
import java.util.Hashtable;
import robocode.AdvancedRobot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class MinimumRisk {
    static Hashtable enemies = new Hashtable();
    static meleeEnemy target;
    static Point2D.Double Destination;
    static Point2D.Double prevPosition;
    static Point2D.Double Position;
    static double Energy;
    private AdvancedRobot _robot;

    public MinimumRisk(AdvancedRobot robot) {
        this._robot = robot;
    }

    public void run() {
        this._robot.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
        prevPosition = Position = new Point2D.Double(this._robot.getX(), this._robot.getY());
        Destination = Position;
        target = new meleeEnemy();
        while (true) {
            Position = new Point2D.Double(this._robot.getX(), this._robot.getY());
            Energy = this._robot.getEnergy();
            if (MinimumRisk.target.isAlive && this._robot.getTime() > 9L) {
                this.doMove();
            }
            this._robot.execute();
        }
    }

    public void doMove() {
        double distanceToTarget = Position.distance(MinimumRisk.target.position);
        double distanceToDestination = Position.distance(Destination);
        if (distanceToDestination < 15.0) {
            double addLast = 1.0 - Math.rint(Math.pow(Math.random(), this._robot.getOthers()));
            Rectangle2D.Double battleField = new Rectangle2D.Double(30.0, 30.0, this._robot.getBattleFieldWidth() - 60.0, this._robot.getBattleFieldHeight() - 60.0);
            int i = 0;
            do {
                Point2D.Double riskPoint;
                if (!battleField.contains(riskPoint = MinimumRisk.calcPoint(Position, Math.min(distanceToTarget * 0.8, 100.0 + 200.0 * Math.random()), Math.PI * 2 * Math.random())) || !(MinimumRisk.evaluate(riskPoint, addLast) < MinimumRisk.evaluate(Destination, addLast))) continue;
                Destination = riskPoint;
            } while (i++ < 200);
            prevPosition = Position;
        } else {
            double angle = MinimumRisk.calcAngle(Destination, Position) - this._robot.getHeadingRadians();
            double direction = 1.0;
            if (Math.cos(angle) < 0.0) {
                angle += Math.PI;
                direction = -1.0;
            }
            this._robot.setAhead(distanceToDestination * direction);
            angle = Utils.normalRelativeAngle((double)angle);
            this._robot.setTurnRightRadians(angle);
            this._robot.setMaxVelocity(Math.abs(angle) > 1.0 ? 0.0 : 8.0);
        }
    }

    public static double evaluate(Point2D.Double p, double addLast) {
        double eval = addLast * 0.08 / p.distanceSq(prevPosition);
        Enumeration Enum2 = enemies.elements();
        while (Enum2.hasMoreElements()) {
            meleeEnemy en = (meleeEnemy)Enum2.nextElement();
            if (!en.isAlive) continue;
            eval += Math.min(en.energy / Energy, 2.0) * (1.0 + Math.abs(Math.cos(MinimumRisk.calcAngle(Position, p) - MinimumRisk.calcAngle(en.position, p)))) / p.distanceSq(en.position);
        }
        return eval;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        meleeEnemy en = (meleeEnemy)enemies.get(e.getName());
        if (en == null) {
            en = new meleeEnemy();
            enemies.put(e.getName(), en);
        }
        en.energy = e.getEnergy();
        en.isAlive = true;
        en.position = MinimumRisk.calcPoint(Position, e.getDistance(), this._robot.getHeadingRadians() + e.getBearingRadians());
        if (!MinimumRisk.target.isAlive || e.getDistance() < Position.distance(MinimumRisk.target.position)) {
            target = en;
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        ((meleeEnemy)MinimumRisk.enemies.get((Object)e.getName())).isAlive = false;
    }

    private static Point2D.Double calcPoint(Point2D.Double p, double dist, double ang) {
        return new Point2D.Double(p.x + dist * Math.sin(ang), p.y + dist * Math.cos(ang));
    }

    private static double calcAngle(Point2D.Double p2, Point2D.Double p1) {
        return Math.atan2(p2.x - p1.x, p2.y - p1.y);
    }

    public class meleeEnemy {
        public Point2D.Double position;
        public double energy;
        public boolean isAlive;
    }
}

