/*
 * Decompiled with CFR 0.152.
 */
package ejbots;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Random;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobocodeFileOutputStream;
import robocode.RoundEndedEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class AngryGrandpappy
extends AdvancedRobot {
    int turnDirection = 1;
    int moveDirection = 1;
    public static final int TRAVEL_DISTANCE = 100;
    public static final int TURN_ANGLE = 30;
    public String fileName = "GrandPappyStats.txt";
    private String filePath = "";
    private String filePathAndName = "";
    private Random rand;
    private boolean RAGE;
    private int timesHit;
    private int enemyHit;
    private int roundsWon;
    private int roundsPlayed;

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.filePathAndName = this.filePath + this.fileName;
        this.setBodyColor(Color.black);
        this.setGunColor(Color.gray);
        this.setRadarColor(Color.darkGray);
        this.out.println("alright, go easy on ol' granpappy.");
        this.rand = new Random();
        this.RAGE = true;
        this.timesHit = 0;
        this.enemyHit = 0;
        while (true) {
            this.turnRight(5 * this.turnDirection);
            if (!this.RAGE) continue;
            this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if (this.RAGE) {
            double absBearing = e.getBearingRadians() + this.getHeadingRadians();
            double latVel = e.getVelocity() * Math.sin(e.getHeadingRadians() - absBearing);
            this.setTurnRadarLeftRadians(this.getRadarTurnRemainingRadians());
            if (Math.random() > 0.9) {
                this.setMaxVelocity(15.0);
            }
            if (e.getDistance() > 150.0) {
                double gunTurnAmt = Utils.normalRelativeAngle((double)(absBearing - this.getGunHeadingRadians() + latVel / 22.0));
                this.setTurnGunRightRadians(gunTurnAmt);
                this.setTurnRightRadians(Utils.normalRelativeAngle((double)(absBearing - this.getHeadingRadians() + latVel / this.getVelocity())));
                this.setAhead((e.getDistance() - 140.0) * (double)this.moveDirection);
                this.setFire(6.0);
            } else {
                double gunTurnAmt = Utils.normalRelativeAngle((double)(absBearing - this.getGunHeadingRadians() + latVel / 15.0));
                this.setTurnGunRightRadians(gunTurnAmt);
                this.setTurnLeft(-90.0 - e.getBearing());
                this.setAhead((e.getDistance() - 140.0) * (double)this.moveDirection);
                this.setFire(6.0);
            }
        } else {
            this.turnDirection = e.getBearing() >= 0.0 ? 1 : -1;
            this.turnRight(e.getBearing());
            this.ahead(5.0);
            for (double distance = e.getDistance(); distance > 0.0 && !this.RAGE; distance -= 200.0) {
                this.turnLeft(30.0);
                this.ahead(100.0);
                this.turnRight(60.0);
                this.ahead(100.0);
                this.turnLeft(30.0);
            }
            this.scan();
        }
    }

    public void onHitRobot(HitRobotEvent e) {
        if (!this.RAGE) {
            this.turnDirection = e.getBearing() >= 0.0 ? 1 : -1;
            this.turnRight(e.getBearing());
            if (e.getEnergy() > 16.0) {
                this.fire(3.0);
            } else if (e.getEnergy() > 10.0) {
                this.fire(2.0);
            } else if (e.getEnergy() > 4.0) {
                this.fire(1.0);
            } else if (e.getEnergy() > 2.0) {
                this.fire(0.5);
            } else if (e.getEnergy() > 0.4) {
                this.fire(0.1);
            }
            this.ahead(40.0);
        }
    }

    public void onHitByBullet(HitByBulletEvent event) {
        ++this.timesHit;
        int n = this.rand.nextInt(5);
        if (n == 0) {
            this.out.println("OH my back");
        } else if (n == 1) {
            this.out.println("That smarts!");
        } else if (n == 2) {
            this.out.println("dang nabbit kids got no respect");
        } else if (n == 3) {
            this.out.println("back in my day we didnt have bullets!");
        } else {
            this.out.println("ayee! you woke me up from my nap! NOW YOU WILL PAY");
        }
        if (this.getEnergy() < 10.0) {
            this.RAGE = false;
            this.out.println("well, this was very enjoyable! i think it's time for my nap now...");
            this.setAdjustGunForRobotTurn(false);
        }
    }

    public void onHitWall(HitWallEvent e) {
        if (this.RAGE) {
            this.moveDirection = -this.moveDirection;
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        ++this.enemyHit;
    }

    public void onWin(WinEvent e) {
        this.out.println("boy, get. rekt.");
        ++this.roundsWon;
    }

    public void onRoundEnded(RoundEndedEvent e) {
        int[] values = this.fileReaderCustom(this.filePathAndName, 4);
        ++this.roundsPlayed;
        this.fileWriterCustom(this.filePathAndName);
        this.out.println("Rounds played: " + this.roundsPlayed);
        this.out.println("Rounds won: " + this.roundsWon);
        this.out.println("i have hit " + this.enemyHit + " enemies.");
        this.out.println("i have been hit " + this.timesHit + " times.");
    }

    private int[] fileReaderCustom(String fileName, int numberOfValues) {
        int[] values = new int[numberOfValues];
        String line = null;
        int lineNumber = 0;
        try {
            FileReader fileReader = new FileReader(this.getDataFile(fileName));
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((line = bufferedReader.readLine()) != null) {
                values[lineNumber] = Integer.parseInt(line);
                ++lineNumber;
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException ex) {
            System.out.println("File GrandPappyStats.txt not found!");
        }
        catch (IOException ex) {
            System.out.println("Error reading file!");
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileWriterCustom(String fileName) {
        try (PrintStream w = null;){
            w = new PrintStream((OutputStream)new RobocodeFileOutputStream(this.getDataFile(fileName)));
            w.println(this.roundsPlayed);
            w.println(this.roundsWon);
            w.println(this.enemyHit);
            w.println(this.timesHit);
        }
    }
}

