/*
 * Decompiled with CFR 0.152.
 */
package lazarecki.mega.index;

import lazarecki.mega.index.Index;
import lazarecki.robot.ModularRobot;
import lazarecki.robot.RobotInfo;
import lazarecki.wave.Wave;
import robocode.Rules;

public class LastDirectionChangeIndex
implements Index {
    private ModularRobot robot;
    private boolean invert;
    private Wave.ClockDirection lastEnemyDirection;
    private long lastEnemyDirectionTime;

    public LastDirectionChangeIndex(ModularRobot robot, boolean invert) {
        this.robot = robot;
        this.invert = invert;
        this.lastEnemyDirection = Wave.ClockDirection.Clockwise;
    }

    public ModularRobot getRobot() {
        return this.robot;
    }

    public void setRobot(ModularRobot robot) {
        this.robot = robot;
    }

    @Override
    public String getName() {
        return "LastDirectionChange";
    }

    @Override
    public int getSegmentIndex(RobotInfo me, RobotInfo enemy) {
        double time;
        if (!this.invert) {
            if (me.clockDirection(enemy) != this.lastEnemyDirection) {
                this.lastEnemyDirection = me.clockDirection(enemy);
                this.lastEnemyDirectionTime = enemy.getTime();
            }
            if (this.getRobot().getFirePower() == 0.0) {
                return 0;
            }
            double time2 = (double)(enemy.getTime() - this.lastEnemyDirectionTime) / (me.distance(enemy) / Rules.getBulletSpeed((double)this.getRobot().getFirePower()));
            if (time2 < 0.1) {
                return 0;
            }
            if (time2 < 0.3) {
                return 1;
            }
            if (time2 < 1.0) {
                return 2;
            }
            return 3;
        }
        if (enemy.clockDirection(me) != this.lastEnemyDirection) {
            this.lastEnemyDirection = enemy.clockDirection(me);
            this.lastEnemyDirectionTime = me.getTime();
        }
        if ((time = (double)(me.getTime() - this.lastEnemyDirectionTime) / (enemy.distance(me) / Rules.getBulletSpeed((double)1.7))) < 0.1) {
            return 0;
        }
        if (time < 0.3) {
            return 1;
        }
        if (time < 1.0) {
            return 2;
        }
        return 3;
    }

    @Override
    public int getSegments() {
        return 4;
    }
}

