/*
 * Decompiled with CFR 0.152.
 */
package jekl.gunnery.guns;

import java.awt.geom.Point2D;
import jekl.Jekyl;
import jekl.gunnery.guns.Fire;
import jekl.gunnery.util.FiringAssistant;
import jekl.gunnery.util.WaveBullet;
import jekl.intelligence.Enemy;
import jekl.util.BotHelp;
import jekl.util.Constants;

public class LinearFire
implements Fire,
Constants {
    protected Jekyl ar;
    protected Point2D.Double impactPoint = new Point2D.Double(0.0, 0.0);
    protected double bulletHeading_deg;
    protected Point2D.Double bulletStartingPoint = new Point2D.Double();
    protected Point2D.Double targetStartingPoint = new Point2D.Double();
    protected double targetHeading;
    protected double targetVelocity;
    protected double bulletPower;
    protected double angleThreshold;
    protected double distance;
    protected double impactTime;
    protected double angularVelocity_rad_per_sec;
    protected double aimingAngle;
    protected double averageVelocity;
    protected double originalGunBearing;

    public LinearFire(Jekyl _ar) {
        this.ar = _ar;
    }

    public void doStats(WaveBullet w) {
    }

    public void doTurn(FiringAssistant fa) {
        Enemy target = this.ar.getTarget();
        this.aimingAngle = this.calculate(fa.calculateFirePower(target));
        this.ar.setTurnGunRightRadians(this.aimingAngle);
    }

    public void doVirtualBullets(double firePower) {
    }

    public double calculate(double bPower) {
        Enemy target = this.ar.getTarget();
        this.angularVelocity_rad_per_sec = target.getChangehead();
        this.bulletStartingPoint.x = this.ar.getX();
        this.bulletStartingPoint.y = this.ar.getY();
        this.targetStartingPoint.x = target.getX();
        this.targetStartingPoint.y = target.getY();
        this.targetHeading = target.getHeading();
        this.targetVelocity = target.getVelocity();
        this.averageVelocity = target.getAverageVelocity();
        this.bulletPower = bPower;
        double vb = 20.0 - 3.0 * this.bulletPower;
        this.impactTime = this.getImpactTime(10.0, 20.0, 0.01);
        this.impactPoint = this.getEstimatedPosition(this.impactTime);
        double dX = this.impactPoint.getX() - this.bulletStartingPoint.getX();
        double dY = this.impactPoint.getY() - this.bulletStartingPoint.getY();
        this.distance = Math.sqrt(dX * dX + dY * dY);
        this.bulletHeading_deg = Math.toDegrees(Math.atan2(dX, dY));
        this.angleThreshold = Math.toDegrees(Math.atan(10.0 / this.distance));
        return Math.toRadians(BotHelp.normalRelativeAngle(this.bulletHeading_deg - this.ar.getGunHeading()));
    }

    public boolean inBattleField() {
        return this.impactPoint.getX() > 0.0 && this.impactPoint.getX() < this.ar.getBattleFieldWidth() && this.impactPoint.getY() > 0.0 && this.impactPoint.getY() < this.ar.getBattleFieldHeight();
    }

    protected Point2D.Double getEstimatedPosition(double time) {
        double x = this.targetStartingPoint.getX() + this.targetVelocity * time * Math.sin(this.targetHeading);
        double y = this.targetStartingPoint.getY() + this.targetVelocity * time * Math.cos(this.targetHeading);
        return new Point2D.Double(x, y);
    }

    private double f(double time) {
        double vb = 20.0 - 3.0 * this.bulletPower;
        Point2D.Double targetPosition = this.getEstimatedPosition(time);
        double dX = targetPosition.getX() - this.bulletStartingPoint.getX();
        double dY = targetPosition.getY() - this.bulletStartingPoint.getY();
        return Math.sqrt(dX * dX + dY * dY) - vb * time;
    }

    private double getImpactTime(double t0, double t1, double accuracy) {
        double X = t1;
        double lastX = t0;
        int iterationCount = 0;
        double lastfX = this.f(lastX);
        while (Math.abs(X - lastX) >= accuracy && iterationCount < 15) {
            ++iterationCount;
            double fX = this.f(X);
            if (fX - lastfX == 0.0) break;
            double nextX = X - fX * (X - lastX) / (fX - lastfX);
            lastX = X;
            X = nextX;
            lastfX = fX;
        }
        return X;
    }

    public void saveData() {
    }
}

