/*
 * Decompiled with CFR 0.152.
 */
package jekl.intelligence;

import java.awt.geom.Point2D;

public class Enemy {
    private static StringBuffer pattern;
    private String name;
    private double bearing;
    private double heading;
    private double velocity;
    private double x;
    private double y;
    private double distance;
    private double changehead;
    private double lastChangehead;
    private double energy;
    private double lastEnergy;
    private long lastScanTime;
    private boolean live = true;
    private int shotsAt = 0;
    private int hits;
    private int scanEvents;
    private double cumulativeDistance = 0.0;
    private double cumulativeVelocity;
    private double cumulativeMissAngle;
    private double absBearing;
    private double lastVelocity;
    private double cumulativeFirewpower = 0.0;
    private long turnOfDeath = 0L;
    private double leadShootAngle;
    private int direction;
    private double arcMovement;
    private double[] arcLength = new double[10000];
    private int historyIndex = 0;

    public Enemy() {
        pattern = new StringBuffer(10000);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getBearing() {
        return this.bearing;
    }

    public void setBearing(double bearing) {
        this.bearing = bearing;
    }

    public double getHeading() {
        return this.heading;
    }

    public void setHeading(double heading) {
        this.heading = heading;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public void setVelocity(double velocity) {
        this.lastVelocity = this.velocity;
        this.velocity = velocity;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    public double getChangehead() {
        return this.changehead;
    }

    public void setChangehead(double _changehead) {
        this.lastChangehead = this.changehead;
        this.changehead = _changehead;
    }

    public double getEnergy() {
        return this.energy;
    }

    public void setEnergy(double energy) {
        this.lastEnergy = this.energy;
        this.energy = energy;
    }

    public boolean isLive() {
        return this.live;
    }

    public void setLive(boolean live) {
        this.live = live;
    }

    public int getShotsAt() {
        return this.shotsAt;
    }

    public void setShotsAt(int shotsAt) {
        this.shotsAt = shotsAt;
    }

    public int getHits() {
        return this.hits;
    }

    public void setHits(int hits) {
        this.hits = hits;
    }

    public long getLastScanTime() {
        return this.lastScanTime;
    }

    public void setLastScanTime(long lastScanTime) {
        this.lastScanTime = lastScanTime;
    }

    public void incrementHits() {
        ++this.hits;
    }

    public void incrementShotsAt() {
        ++this.shotsAt;
    }

    public void incrementScanEvents() {
        ++this.scanEvents;
    }

    public void incrementCumulativeVelocity(double velocity) {
        this.cumulativeVelocity += velocity;
    }

    public double getAverageVelocity() {
        return this.cumulativeVelocity / (double)this.scanEvents;
    }

    public void incrementMissAngle(double ang) {
        this.cumulativeMissAngle += ang;
    }

    public double calculateAverageMissAngle() {
        return this.cumulativeMissAngle / (double)(this.shotsAt - this.hits);
    }

    public double getArcMovement() {
        return this.arcMovement;
    }

    public void setArcMovement(double arcMovement) {
        this.arcMovement = arcMovement;
    }

    public void addArcHistory(double p) {
        this.arcLength[++this.historyIndex] = this.arcLength[this.historyIndex - 1] + p;
    }

    public void appendPattern(double arcMovement) {
        pattern.append((char)arcMovement);
    }

    public StringBuffer getPatternBuffer() {
        return pattern;
    }

    public double[] getArcLength() {
        return this.arcLength;
    }

    public double getAbsBearing() {
        return this.absBearing;
    }

    public void setAbsBearing(double absBearing) {
        this.absBearing = absBearing;
    }

    public int getHistoryIndex() {
        return this.historyIndex;
    }

    public void setHistoryIndex(int historyIndex) {
        this.historyIndex = historyIndex;
    }

    public int getScanEvents() {
        return this.scanEvents;
    }

    public void setScanEvents(int scanEvents) {
        this.scanEvents = scanEvents;
    }

    public void incrementCumulativeDistance(double distance) {
        this.cumulativeDistance += distance;
    }

    public double getAverageDistance() {
        return this.cumulativeDistance / (double)this.scanEvents;
    }

    public void incrementCumFirePwr(double power) {
        this.cumulativeFirewpower += power;
    }

    public double getAverageBulletPower() {
        return this.cumulativeFirewpower / (double)this.shotsAt;
    }

    public long getTurnOfDeath() {
        return this.turnOfDeath;
    }

    public void setTurnOfDeath(long turnOfDeath) {
        this.turnOfDeath = turnOfDeath;
    }

    public double getLeadShootAngle() {
        return this.leadShootAngle;
    }

    public void setLeadShootAngle(double leadShootAngle) {
        this.leadShootAngle = leadShootAngle;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public double getLastVelocity() {
        return this.lastVelocity;
    }

    public double getLastChangehead() {
        return this.lastChangehead;
    }

    public Point2D.Double getCurrentLoc() {
        return new Point2D.Double(this.x, this.y);
    }

    public double getLastEnergy() {
        return this.lastEnergy;
    }
}

