/*
 * Decompiled with CFR 0.152.
 */
package voidious.utils.trace;

import java.util.Stack;
import java.util.Vector;
import java.util.regex.Pattern;
import voidious.utils.trace.TraceEntry;

public class TraceLogger {
    protected static final int INDENT_AMOUNT = 2;
    protected Pattern[] _includePatterns;
    protected Pattern[] _excludePatterns;
    protected Stack<Long> _times;
    protected Vector<TraceEntry> _trace;
    protected int indent;

    public TraceLogger(String[] includeStrs, String[] excludeStrs) {
        this._includePatterns = new Pattern[includeStrs.length];
        this._excludePatterns = new Pattern[excludeStrs.length];
        TraceLogger.fillPattern(this._includePatterns, includeStrs);
        TraceLogger.fillPattern(this._excludePatterns, excludeStrs);
        this._times = new Stack();
        this._trace = new Vector();
        this.indent = 0;
    }

    public void log(String className, String methodName, String params, boolean entering) {
        int x;
        String classMethod = className + "." + methodName;
        boolean doTrace = false;
        for (x = 0; x < this._includePatterns.length; ++x) {
            if (!this._includePatterns[x].matcher(classMethod).matches()) continue;
            doTrace = true;
            break;
        }
        if (doTrace) {
            for (x = 0; x < this._excludePatterns.length; ++x) {
                if (!this._excludePatterns[x].matcher(classMethod).matches()) continue;
                doTrace = false;
                break;
            }
        }
        if (doTrace) {
            TraceEntry newEntry = new TraceEntry(className, methodName, params, entering);
            this._trace.add(newEntry);
            this.printTraceEntry(newEntry);
            if (entering) {
                this._times.push(newEntry.getNanoTime());
            }
        }
    }

    public void printTraceEntry(TraceEntry entry) {
        String traceString = "";
        if (entry.isEntering()) {
            for (int y = 0; y < this.indent * 2; ++y) {
                traceString = traceString + " ";
            }
            ++this.indent;
            traceString = traceString + "+ " + entry.getClassName() + "." + entry.getMethodName() + "(" + entry.getParams() + ") @ " + entry.getNanoTime();
        } else {
            --this.indent;
            long deltaTime = entry.getNanoTime() - this._times.pop();
            for (int y = 0; y < this.indent * 2; ++y) {
                traceString = traceString + " ";
            }
            traceString = traceString + "- " + entry.getClassName() + "." + entry.getMethodName() + "(" + entry.getParams() + ") > " + deltaTime;
        }
        System.out.println(traceString);
    }

    protected static void fillPattern(Pattern[] patterns, String[] patternStrs) {
        for (int x = 0; x < patterns.length; ++x) {
            patterns[x] = Pattern.compile(patternStrs[x]);
        }
    }
}

