/*
 * Decompiled with CFR 0.152.
 */
package wiki;

import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;
import vuen.fractal.FractalE;

public class MoOOo
extends AdvancedRobot {
    FractalE engine = new FractalE(this);
    private static double preDiffAngle;
    private static double power;
    private static double enemyEnergy;
    private static double lastEnemyBulletPower;
    private static long enemyLastFireTime;

    public MoOOo() {
        this.engine.move = false;
    }

    public void run() {
        this.engine.run();
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.engine.onHitByBullet(e);
    }

    public void onHitWall(HitWallEvent e) {
        this.engine.onHitWall(e);
    }

    public void onHitRobot(HitRobotEvent e) {
        this.engine.onHitRobot(e);
    }

    public void onRobotDeath(RobotDeathEvent e) {
        this.engine.onRobotDeath(e);
    }

    public void onBulletHit(BulletHitEvent e) {
        this.engine.onBulletHit(e);
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        this.engine.onBulletHitBullet(e);
    }

    public void onBulletMissed(BulletMissedEvent e) {
        this.engine.onBulletMissed(e);
    }

    public void onWin(WinEvent e) {
        this.engine.onWin(e);
    }

    public void onDeath(DeathEvent e) {
        this.engine.onDeath(e);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.engine.onScannedRobot(e);
        this.doCigaretMovement(e);
    }

    public void doCigaretMovement(ScannedRobotEvent e) {
        boolean isRam;
        double edistance;
        long time = this.getTime();
        Point2D.Double nextP = null;
        Point2D.Double myPos = new Point2D.Double(this.getX(), this.getY());
        double absBearing = Utils.normalRelativeAngle((double)(e.getBearingRadians() + this.getHeadingRadians()));
        double moveDistance = edistance = e.getDistance();
        Point2D.Double enemyPos = MoOOo.nextPoint(myPos, absBearing, edistance);
        Point2D.Double centerPos = new Point2D.Double(this.getBattleFieldWidth() / 2.0, this.getBattleFieldHeight() / 2.0);
        double energyChange = enemyEnergy - e.getEnergy();
        enemyEnergy = e.getEnergy();
        if (Math.abs(energyChange - 1.55) < 1.46) {
            lastEnemyBulletPower = energyChange;
            enemyLastFireTime = time;
        }
        boolean bl = isRam = time - enemyLastFireTime > 50L;
        if (Math.abs(this.getDistanceRemaining()) < 53.0 || isRam) {
            double moveAngle;
            if (Math.abs(energyChange - 1.55) < 1.46 || edistance < 200.0) {
                double L;
                double xieAngle = Math.abs((absBearing + Math.PI * 2) % 1.5707963267948966);
                boolean isCloseToCenter = myPos.distance(centerPos) < centerPos.distance(0.0, 0.0) / 2.0;
                boolean isVerticle = xieAngle < 0.39269908169872414 || xieAngle > 2.748893571891069 || isCloseToCenter;
                double disAngle = 2.0 * Math.asin(4.0 / (20.0 - lastEnemyBulletPower * 3.0));
                if (isVerticle) {
                    disAngle = Math.asin(8.0 / (20.0 - lastEnemyBulletPower * 3.0));
                }
                disAngle += 25.0 / edistance;
                moveDistance = Math.max(170.0, moveDistance);
                do {
                    moveAngle = Math.random() * disAngle * 2.0 - disAngle;
                    L = moveDistance;
                    if (this.getEnergy() > 10.0) {
                        L *= 0.95;
                    }
                    if (isVerticle) {
                        L /= Math.cos(moveAngle);
                    }
                    moveDistance -= 10.0;
                } while (this.distanceToWall(nextP = MoOOo.nextPoint(enemyPos, absBearing + moveAngle, -L)) < 24.0);
            } else if (this.getDistanceRemaining() == 0.0) {
                nextP = MoOOo.nextPoint(enemyPos, absBearing + 1.0E-6, -edistance);
            }
            if (isRam) {
                nextP = enemyPos;
            }
            if (nextP != null) {
                moveAngle = Utils.normalRelativeAngle((double)(MoOOo.getAngle(nextP, myPos) - this.getHeadingRadians()));
                this.setAhead((double)(moveAngle == (moveDistance = Math.atan(Math.tan(moveAngle))) ? 1 : -1) * myPos.distance(nextP));
                this.setTurnRightRadians(moveDistance);
            }
        }
        this.setMaxVelocity(Math.abs(this.getTurnRemaining()) > 45.0 ? 0.0 : 8.0);
    }

    public double distanceToWall(Point2D.Double p) {
        return Math.min(Math.min(p.x, this.getBattleFieldWidth() - p.x), Math.min(p.y, this.getBattleFieldHeight() - p.y));
    }

    public static Point2D.Double nextPoint(Point2D.Double originPoint, double angle, double distance) {
        return new Point2D.Double(originPoint.x + Math.sin(angle) * distance, originPoint.y + Math.cos(angle) * distance);
    }

    public static double getAngle(Point2D.Double p2, Point2D.Double p1) {
        return Math.atan2(p2.x - p1.x, p2.y - p1.y);
    }

    static {
        power = 0.0;
    }
}

