/*
 * Decompiled with CFR 0.152.
 */
package wcsv.Engineer.Movement;

import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.ListIterator;
import robocode.AdvancedRobot;
import wcsv.Engineer.Movement.Movement;
import wcsv.Engineer.Movement.MovementPredictor;
import wcsv.Engineer.Movement.predictionData;
import wcsv.Engineer.Utilities.ForceVector;
import wcsv.Engineer.Utilities.Map;
import wcsv.Engineer.Utilities.Target;
import wcsv.Engineer.Utilities.Utilities;
import wcsv.Engineer.Utilities.Wave;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WaveSurfingMovement
extends Movement {
    public static final double[] offsets;
    public static final int countIndex;
    private static final int fwd = 0;
    private static final int rev = 1;
    private static final int stop = 2;
    private static int missedWaves;
    private static final double[] initialBuffer;
    public static int enemyHits;
    public static int enemyShots;
    private SurfPath[] paths;
    private int lastPath;
    private int nonStop;
    private double minDistance;
    private double minDistanceDelta;
    private double diveBearing;
    public Wave wave;
    public Point2D.Double loc;
    private Map data;
    private AdvancedRobot robot;
    public LinkedList waves;
    public LinkedList nonBreaking;
    public double lastEnemyBulletPower;
    public Point2D.Double hitByBullet;
    public Point2D.Double BulletHitBullet;
    private ForceVector nextMove;
    private Target[] myPastData;
    private Target[] enemyPastData;
    public double enemyDamagePerRound;
    public double enemyDamageThisRound;

    public void operate(Target enemy, Target me) {
        this.lastEnemyBulletPower = enemy.lastEnergy - enemy.energy - enemy.damageDoneThisTick;
        if (this.lastEnemyBulletPower > 0.09 && this.lastEnemyBulletPower < 3.01) {
            ++enemyShots;
            this.wave = new Wave(this.enemyPastData[0] != null ? this.enemyPastData[0] : enemy, this.myPastData[1] != null ? this.myPastData[1] : me, this.lastEnemyBulletPower, (int)this.robot.getTime() - 2, true);
            this.waves.add(this.wave);
        }
        this.updatePastData(me, enemy);
        if (this.hitByBullet != null) {
            Wave hittingWave = Wave.getClosestWave(this.hitByBullet, this.waves, (int)this.robot.getTime());
            this.update(enemy, me, this.hitByBullet, hittingWave);
            ++enemyHits;
            if (hittingWave != null) {
                this.enemyDamageThisRound += Utilities.bulletDamage(hittingWave.velocity);
            }
        }
        if (this.BulletHitBullet != null) {
            this.update(enemy, me, this.BulletHitBullet, Wave.getClosestWave(this.BulletHitBullet, this.waves, (int)this.robot.getTime()));
        }
        this.hitByBullet = null;
        this.BulletHitBullet = null;
        this.nextMove = this.computeNextMove(enemy, me, this.nonBreaking);
        double distance = this.nextMove.magnitude;
        double angle = Utilities.relativeAngle(this.nextMove.bearing - me.heading);
        if (Math.abs(angle) > 1.5707963267948966) {
            distance *= -1.0;
            angle = angle > 0.0 ? (angle -= Math.PI) : (angle += Math.PI);
        }
        this.robot.setTurnRightRadians(angle);
        this.robot.setMaxVelocity(Math.abs(angle) >= MovementPredictor.slowTurn ? 0.0 : this.nextMove.velocity);
        this.robot.setAhead(distance);
        ListIterator it = this.waves.listIterator();
        this.nonBreaking.clear();
        while (it.hasNext()) {
            Wave curr = (Wave)it.next();
            double wDist = curr.distanceToPoint(me.location, (int)this.robot.getTime());
            if (wDist < -50.0) {
                it.remove();
                continue;
            }
            if (!(wDist >= curr.velocity * (double)2)) continue;
            this.nonBreaking.add(curr);
        }
    }

    public void update(Target enemy, Target newData, Point2D.Double hitLocation, Wave w) {
        if (w == null) {
            System.out.println("No Matching Wave: Distance = " + Utilities.distance(hitLocation, enemy.location));
            ++missedWaves;
            return;
        }
        double[] vect = this.createVector(w.targetRobot, w);
        Map.Node BMU = this.data.add(vect);
        double bearingChange = w.computeCentralBearingChange(hitLocation) * (double)w.targetRobot.orbitDir;
        double maxEscapeAngle = Utilities.maxEscapeAngle_Velocity(w.velocity);
        double mid = Utilities.getSegment(bearingChange / maxEscapeAngle, offsets);
        this.data.combineRolling(vect, BMU, 1.0, mid);
        ++BMU.uses;
    }

    public ForceVector computeNextMove(Target enemy, Target me, LinkedList waves) {
        boolean rDive;
        if (!waves.isEmpty()) {
            Collections.sort(waves, new WaveSorter(me.location));
            Wave w = (Wave)waves.getFirst();
            double bearingOffset = 1.5707963267948966 * (Utilities.distance(me.location, w.sourceRobot.location) / this.minDistance);
            this.paths[0] = new SurfPath(100.0, Utilities.absoluteAngle(Utilities.absoluteAngleToPoint(w.sourceRobot.location, me.location) + bearingOffset * (double)me.orbitDir), 8.0, me, enemy, w, me.orbitDir);
            this.paths[1] = new SurfPath(100.0, Utilities.absoluteAngle(Utilities.absoluteAngleToPoint(w.sourceRobot.location, me.location) + bearingOffset * (double)(-me.orbitDir)), 8.0, me, enemy, w, -me.orbitDir);
            this.paths[2] = new SurfPath(0.0, me.heading, 0.0, me, enemy, w, this.paths[this.lastPath].orbital);
            ListIterator it = waves.listIterator();
            while (it.hasNext()) {
                w = (Wave)it.next();
                double[] buff = this.data.get(this.createVector(w.targetRobot, w));
                buff = buff != null ? buff : initialBuffer;
                this.paths[0].addDanger(w, me, enemy, buff);
                this.paths[1].addDanger(w, me, enemy, buff);
                this.paths[2].addDanger(w, me, enemy, buff);
            }
        } else {
            double bearingOffset = 1.5707963267948966 * (enemy.distance / this.minDistance);
            this.paths[0] = new SurfPath(100.0, Utilities.absoluteAngle(Utilities.absoluteAngleToPoint(enemy.location, me.location) + bearingOffset * (double)me.orbitDir), 8.0, me, enemy, me.orbitDir);
            this.paths[1] = new SurfPath(100.0, Utilities.absoluteAngle(Utilities.absoluteAngleToPoint(enemy.location, me.location) + bearingOffset * (double)(-me.orbitDir)), 8.0, me, enemy, -me.orbitDir);
            this.paths[2] = new SurfPath(0.0, this.paths[this.lastPath].path.bearing, 0.0, me, enemy, this.paths[this.lastPath].orbital);
        }
        boolean bl = false;
        if (this.paths[0].diveDanger > 0.0) {
            bl = true;
        }
        boolean fDive = bl;
        boolean bl2 = false;
        if (this.paths[1].diveDanger > 0.0) {
            bl2 = rDive = true;
        }
        if (enemy.distance <= 200.0) {
            this.paths[2].diveDanger = Double.MAX_VALUE;
            this.paths[2].danger = Double.MAX_VALUE;
        }
        if (fDive && rDive) {
            this.lastPath = this.lastPath == 0 ? (this.paths[0].diveDanger <= this.paths[1].diveDanger ? 0 : 1) : (this.paths[0].diveDanger < this.paths[1].diveDanger ? 0 : 1);
        } else if (fDive && !rDive) {
            this.lastPath = this.paths[1].danger <= this.paths[2].danger ? 1 : 2;
            this.nonStop = 1;
        } else if (!fDive && rDive) {
            this.lastPath = this.paths[0].danger <= this.paths[2].danger ? 0 : 2;
            this.nonStop = 0;
        } else {
            this.lastPath = this.getBestPath(this.lastPath);
        }
        if (this.lastPath != 2) {
            this.nonStop = this.lastPath;
        }
        return this.paths[this.lastPath].path;
    }

    public int getBestPath(int last) {
        int best = last;
        int i = 0;
        while (i < this.paths.length) {
            if (this.paths[i].danger < this.paths[best].danger) {
                best = i;
            }
            ++i;
        }
        return best;
    }

    public double getDiveDanger(double moveBearing, double enemyBearing) {
        double d = 0.0;
        double dive = Math.abs(Utilities.relativeAngle(enemyBearing - moveBearing));
        if ((dive = Math.max(dive, 0.01)) < this.diveBearing) {
            d += this.diveBearing / dive;
        }
        return d;
    }

    public void reset() {
        this.enemyDamagePerRound = Utilities.rollingAvg(this.enemyDamagePerRound, this.enemyDamageThisRound, this.robot.getRoundNum());
        this.enemyDamageThisRound = 0.0;
        this.minDistance = this.enemyDamagePerRound > 50.0 ? 800.0 : (this.enemyDamagePerRound > 35.0 ? 600.0 : (this.enemyDamagePerRound > 20.0 ? 500.0 : 400.0));
        this.waves = new LinkedList();
        this.nonBreaking = new LinkedList();
        this.myPastData = new Target[2];
        this.enemyPastData = new Target[2];
        this.hitByBullet = null;
        this.BulletHitBullet = null;
        System.out.print("Total enemy hits: ");
        System.out.println(enemyHits);
        int n = 0;
        if (Math.random() < 0.5) {
            n = 1;
        }
        this.lastPath = this.nonStop = 1 - n;
        System.out.println("Total Missed Waves: " + missedWaves);
        System.out.println("Nodes Used By Movement: " + this.data.size);
    }

    private final void updatePastData(Target me, Target enemy) {
        this.myPastData[1] = this.myPastData[0] != null ? this.myPastData[0].cloneTarget() : me.cloneTarget();
        this.myPastData[0] = me.cloneTarget();
        this.enemyPastData[1] = this.enemyPastData[0] != null ? this.enemyPastData[0].cloneTarget() : enemy.cloneTarget();
        this.enemyPastData[0] = enemy.cloneTarget();
    }

    public void onHitByBullet(Point2D.Double location) {
        this.hitByBullet = location;
    }

    public void onBulletHitBullet(Point2D.Double location) {
        this.BulletHitBullet = location;
    }

    public double[] createVector(Target t, Wave wave) {
        return new double[]{Math.abs(t.lateralVelocity) / 8.0, (t.advancingVelocity + 8.0) / 16.0, Math.min(70.0, t.distance / wave.velocity) / 70.0, (t.calculateAcceleration() + (double)2) / (double)3, Utilities.wallCollisionAngle(t, wave.sourceRobot.location, 1.0, 0.7853981633974483) / 0.7853981633974483, Utilities.wallCollisionAngle(t, wave.sourceRobot.location, -1.0, 0.7853981633974483) / 0.7853981633974483};
    }

    private final /* synthetic */ void this() {
        this.lastPath = 0;
        this.nonStop = 0;
        this.minDistance = 450.0;
        this.minDistanceDelta = 30.0;
        this.diveBearing = Math.toRadians(40.0);
        this.wave = null;
        this.loc = null;
        this.lastEnemyBulletPower = 0.0;
        this.hitByBullet = null;
        this.BulletHitBullet = null;
        this.enemyDamagePerRound = 0.0;
        this.enemyDamageThisRound = 0.0;
    }

    public WaveSurfingMovement(AdvancedRobot r) {
        this.this();
        this.paths = new SurfPath[3];
        this.data = new Map(6, Math.sqrt(6.0) / 10.0);
        this.robot = r;
        this.waves = new LinkedList();
        this.nonBreaking = new LinkedList();
        this.myPastData = new Target[2];
        this.enemyPastData = new Target[2];
        int i = 0;
        while (i < initialBuffer.length) {
            WaveSurfingMovement.initialBuffer[i] = 1.0 / (Math.abs(20.0 - (double)i) + 1.0);
            ++i;
        }
    }

    static {
        double[] dArray = new double[41];
        dArray[0] = -1.0;
        dArray[1] = -0.95;
        dArray[2] = -0.9;
        dArray[3] = -0.85;
        dArray[4] = -0.8;
        dArray[5] = -0.75;
        dArray[6] = -0.7;
        dArray[7] = -0.65;
        dArray[8] = -0.6;
        dArray[9] = -0.55;
        dArray[10] = -0.5;
        dArray[11] = -0.45;
        dArray[12] = -0.4;
        dArray[13] = -0.35;
        dArray[14] = -0.3;
        dArray[15] = -0.25;
        dArray[16] = -0.2;
        dArray[17] = -0.15;
        dArray[18] = -0.1;
        dArray[19] = -0.05;
        dArray[21] = 0.05;
        dArray[22] = 0.1;
        dArray[23] = 0.15;
        dArray[24] = 0.2;
        dArray[25] = 0.25;
        dArray[26] = 0.3;
        dArray[27] = 0.35;
        dArray[28] = 0.4;
        dArray[29] = 0.45;
        dArray[30] = 0.5;
        dArray[31] = 0.55;
        dArray[32] = 0.6;
        dArray[33] = 0.65;
        dArray[34] = 0.7;
        dArray[35] = 0.75;
        dArray[36] = 0.8;
        dArray[37] = 0.85;
        dArray[38] = 0.9;
        dArray[39] = 0.95;
        dArray[40] = 1.0;
        offsets = dArray;
        countIndex = offsets.length;
        missedWaves = 0;
        initialBuffer = new double[41];
        enemyHits = 0;
        enemyShots = 0;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class WaveSorter
    implements Comparator {
        private Point2D.Double loc;

        public int compare(Object w1, Object w2) {
            if (((Wave)w1).distanceToPoint(this.loc, (int)WaveSurfingMovement.this.robot.getTime()) < ((Wave)w2).distanceToPoint(this.loc, (int)WaveSurfingMovement.this.robot.getTime())) {
                return -1;
            }
            return 1;
        }

        public WaveSorter(Point2D.Double l) {
            this.loc = l;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class SurfPath {
        public ForceVector path;
        public predictionData predData;
        public Point2D.Double destination;
        public double diveDanger;
        public double danger;
        public double orbital;
        public int bin;

        public void addDanger(Wave w, Target me, Target enemy, double[] buffer) {
            this.predData = MovementPredictor.projectLocation(this.predData, w, me, enemy, this.orbital, WaveSurfingMovement.this.minDistance, this.path.velocity);
            this.destination = this.predData.location;
            this.bin = Math.min(Utilities.getSegment(w.computeCentralBearingChange(this.destination) * (double)w.targetRobot.orbitDir / Utilities.maxEscapeAngle_Velocity(w.velocity), offsets), offsets.length - 1);
            this.danger += buffer[this.bin] / Utilities.square(w.distanceToPoint(me.location, (int)WaveSurfingMovement.this.robot.getTime()));
        }

        private final /* synthetic */ void this() {
            this.orbital = 1.0;
        }

        public SurfPath(double dist, double bearing, double velocity, Target me, Target enemy, Wave w, double orbit) {
            this.this();
            this.path = new ForceVector(dist, MovementPredictor.wallCorrectedAngle(bearing, me.location, orbit), velocity);
            this.danger = 0.0;
            this.diveDanger = this.path.bearing != bearing ? WaveSurfingMovement.this.getDiveDanger(this.path.bearing, enemy.absoluteBearing) : 0.0;
            this.orbital = orbit;
            this.predData = new predictionData(me.location, me.heading, me.velocity, (int)WaveSurfingMovement.this.robot.getTime());
        }

        public SurfPath(double dist, double bearing, double velocity, Target me, Target enemy, double orbit) {
            this.this();
            this.path = new ForceVector(dist, MovementPredictor.wallCorrectedAngle(bearing, me.location, orbit), velocity);
            this.destination = Utilities.projectPoint(me.location, this.path.bearing, velocity);
            this.danger = this.diveDanger = 1.0 / Utilities.distance(this.destination, enemy.location);
            this.orbital = orbit;
            this.predData = new predictionData(me.location, me.heading, me.velocity, (int)WaveSurfingMovement.this.robot.getTime());
        }
    }
}

