/*
 * Decompiled with CFR 0.152.
 */
package Krabb.fe4r;

import Krabb.Vector2D;
import Krabb.fe4r.Input;
import Krabb.fe4r.NGun;
import Krabb.fe4r.NeuralNetwork;
import Krabb.krabby2.EnemyStats;
import Krabb.krabby2.MateStats;
import Krabb.krabby2.MyWave;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import robocode.util.Utils;

public class NNetwork {
    static final int NINPUT = 2;
    static final int NTRAIN = 50;
    private static ArrayList inoutput = new ArrayList();
    NeuralNetwork nn;

    public void train() {
        if (inoutput.size() == 0) {
            return;
        }
        int i = 0;
        while (i < 50) {
            int rnd = (int)(Math.random() * (double)inoutput.size());
            this.nn.train(((Input)NNetwork.inoutput.get((int)rnd)).input, ((Input)NNetwork.inoutput.get((int)rnd)).output);
            ++i;
        }
    }

    public void newShot(NGun g, MyWave w, double[] output) {
        inoutput.add(inoutput.size(), new Input(this.getInput(g, w), output));
    }

    public double[] forwardPass(NGun g, MyWave w) {
        return this.nn.forwardPass(this.getInput(g, w));
    }

    private final double[] getInput(NGun g, MyWave w) {
        double[] input = new double[2];
        EnemyStats oe = g.getEnemyTimeStats((long)w.t);
        input[0] = this.getFT(w, g);
        input[1] = this.getLV(w, g);
        return input;
    }

    private final double getLV(MyWave w, NGun g) {
        EnemyStats e = g.getEnemyTimeStats((int)w.t);
        MateStats m = g.getMateTimeStats((int)w.t);
        if (e == null) {
            return 0.0;
        }
        return Math.sin(e.p.Subtract(m.p).getA() - e.v.getA()) * e.v.Length() / 16.0;
    }

    private final double getB(MyWave w, NGun g) {
        EnemyStats e = g.getEnemyTimeStats((int)w.t);
        MateStats m = g.getMateTimeStats((int)w.t);
        if (e == null) {
            return 0.0;
        }
        return Math.sin(Utils.normalRelativeAngle((double)e.v.Subtract(m.p.Subtract(e.p)).getA()) / (Math.PI * 2));
    }

    private final double getP(MyWave w, NGun g) {
        return w.pow;
    }

    private final double getFT(MyWave w, NGun g) {
        EnemyStats oe = g.getEnemyTimeStats((long)w.t);
        return oe.d / (20.0 - (double)3 * w.pow);
    }

    private final double getLChange(MyWave w, NGun g) {
        EnemyStats e = g.getEnemyTimeStats((int)w.t);
        if (e == null) {
            return 0.0;
        }
        return (double)e.time - e.lchange;
    }

    private final double getLGF(MyWave w, NGun g) {
        EnemyStats e = g.getEnemyTimeStats((int)w.t);
        if (e == null) {
            return 0.0;
        }
        return e.lastgf;
    }

    public double getDCorner(MyWave w, NGun g) {
        EnemyStats e = g.getEnemyTimeStats((int)w.t);
        if (e == null) {
            return 0.0;
        }
        double d = 0.0;
        d = e.p.Length();
        d = Math.min(e.p.Subtract(new Vector2D(new Point2D.Double(0.0, 600.0))).Length(), d);
        d = Math.min(e.p.Subtract(new Vector2D(new Point2D.Double(800.0, 0.0))).Length(), d);
        d = Math.min(e.p.Subtract(new Vector2D(new Point2D.Double(800.0, 600.0))).Length(), d);
        return d;
    }

    public double getDWall(MyWave w, NGun g) {
        EnemyStats e = g.getEnemyTimeStats((int)w.t);
        if (e == null) {
            return 0.0;
        }
        double d = 0.0;
        d = e.p.getX();
        d = Math.min(e.p.getY(), d);
        d = Math.min(800.0 - e.p.getX(), d);
        d = Math.min(600.0 - e.p.getY(), d);
        return d;
    }

    NNetwork() {
        int[] struct = new int[]{2, 20, 5, 1};
        this.nn = new NeuralNetwork(struct);
    }
}

