/*
 * Decompiled with CFR 0.152.
 */
package TNT;

import TNT.FightingStrategy;
import TNT.ReadyToFireCondition;
import TNT.Recon;
import TNT.TNT;
import TNT.TNTMath;
import robocode.Condition;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;

abstract class AbstractFightingStrategy
implements FightingStrategy {
    public static final int DEFAULT_DOMINENCE = 1;
    private static final double MAX_GUN_TURN_FOR_FIRE = 1.5707963267948966;
    protected TNT m_owner = null;

    public final void fire() {
        double shotPower;
        double shotVelocity;
        double fireAngle;
        Recon m_currentTarget;
        if (this.m_owner.getGunTurnRemaining() == 0.0 && (m_currentTarget = this.getTarget()) != null && !Double.isNaN(fireAngle = TNTMath.determineCurvedShotAngle(this.m_owner, m_currentTarget, shotVelocity = TNTMath.determineShotVelocity(shotPower = TNTMath.factorLife(this.getPower(m_currentTarget), m_currentTarget.getLife()))))) {
            double gunAngle = TNTMath.normalRelativeAngle(fireAngle - this.m_owner.getGunHeadingRadians());
            this.m_owner.setTurnGunRightRadians(gunAngle);
            if (Math.abs(gunAngle) < 1.5707963267948966 && this.shouldShoot(m_currentTarget)) {
                this.m_owner.addCustomEvent((Condition)new ReadyToFireCondition(this.m_owner, shotPower));
            }
        }
    }

    public int getStrategyDominence() {
        return 1;
    }

    public void gotShot(HitByBulletEvent in_event) {
    }

    public void gotCollision(HitRobotEvent in_event) {
    }

    public abstract Recon getTarget();

    public abstract boolean shouldShoot(Recon var1);

    public abstract double getPower(Recon var1);

    public abstract boolean shouldUseStrategy();

    public abstract boolean expiredStrategy();

    public AbstractFightingStrategy(TNT in_owner) {
        this.m_owner = in_owner;
    }
}

