/*
 * Decompiled with CFR 0.152.
 */
package dmh.robocode.data;

import dmh.robocode.data.Location;
import dmh.robocode.utils.Geometry;
import robocode.ScannedRobotEvent;

public class RadarObservation {
    private long timeSeen;
    private Location location;
    private double velocity;
    private double heading;
    private double energy;
    private double distance;

    public RadarObservation(ScannedRobotEvent event, Location myLocation, double myHeading, RadarObservation previousObservation) {
        this.location = Geometry.getLocationAtBearing(myLocation, event.getBearing() + myHeading, event.getDistance());
        this.timeSeen = event.getTime();
        this.velocity = event.getVelocity();
        this.heading = event.getHeading();
        this.energy = event.getEnergy();
        this.distance = event.getDistance();
        this.fixVelocityUsingPreviousObservation(previousObservation);
    }

    public double getDistance() {
        return this.distance;
    }

    public double getHeading() {
        return this.heading;
    }

    public long getTimeSeen() {
        return this.timeSeen;
    }

    public Location getLocation() {
        return this.location;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public double getEnergy() {
        return this.energy;
    }

    private void fixVelocityUsingPreviousObservation(RadarObservation previousObservation) {
        if (this.velocity == 0.0 && previousObservation != null && previousObservation.getTimeSeen() == this.timeSeen - 1L) {
            this.velocity = Geometry.getDistanceBetweenLocations(previousObservation.getLocation(), this.location);
            double forwardHeading = Geometry.getBearingBetweenLocations(previousObservation.getLocation(), this.location);
            if (Math.abs(Geometry.getRelativeBearing(forwardHeading, this.heading)) > 90.0) {
                this.velocity = -this.velocity;
            }
        }
    }
}

