/*
 * Decompiled with CFR 0.152.
 */
package de.erdega.robocode;

import de.erdega.robocode.base.AbstractConditionHandler;
import de.erdega.robocode.base.AbstractRadar;
import de.erdega.robocode.base.AbstractRadarTurnCompleteConditionHandler;
import de.erdega.robocode.base.AnalyzedScannedRobotEvent;
import de.erdega.robocode.base.IRobotAddon;
import robocode.AdvancedRobot;
import robocode.CustomEvent;
import robocode.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmartRadar<T extends AdvancedRobot>
extends AbstractRadar {
    private final T _robot;
    private final AbstractConditionHandler RADAR_TURN_COMPLETE;

    public SmartRadar(T robot) {
        this._robot = robot;
        this.RADAR_TURN_COMPLETE = new AbstractRadarTurnCompleteConditionHandler((AdvancedRobot)this._robot){

            public void onCustomEvent(CustomEvent event) {
                SmartRadar.this.onRadarTurnComplete(event);
            }
        };
    }

    protected void onRadarTurnComplete(CustomEvent event) {
        this._robot.setTurnRadarRight(1000000.0);
    }

    @Override
    public void handleScannedRobotEvent(AnalyzedScannedRobotEvent event) {
        this._robot.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(event.getEnemyBearing().getPhi() - event.getRobotRadarHeading())));
    }

    @Override
    public void init() {
        this._robot.setTurnRadarRight(1.0E9);
        ((IRobotAddon)this._robot).addCustomEvent(this.RADAR_TURN_COMPLETE);
    }
}

