/*
 * Decompiled with CFR 0.152.
 */
package pedersen.core;

import java.awt.Graphics2D;
import pedersen.core.Combatant;
import pedersen.core.Competitor;
import pedersen.core.EventProcessor;
import pedersen.core.Foundation;
import pedersen.core.GameState;
import pedersen.core.Instructions;
import pedersen.core.Teammate;
import pedersen.debug.DebuggableBase;
import pedersen.debug.Metrics;
import pedersen.debug.Persistence;
import pedersen.debug.Stopwatches;
import pedersen.debug.renderable.GraphicalDebugger;
import pedersen.divination.BaseCombatWave;
import pedersen.divination.CombatWaveBank;
import pedersen.divination.FiringSolution;
import pedersen.divination.TargetAnalysis;
import pedersen.opponent.Target;
import pedersen.opponent.TargetBank;
import pedersen.opponent.TargetFactory;
import pedersen.physics.Snapshot;
import pedersen.physics.SnapshotImpl;
import pedersen.physics.Vehicle;
import pedersen.systems.CommunicationSubsystem;
import pedersen.systems.ScannerSubsystem;
import pedersen.systems.TurretSubsystem;
import pedersen.systems.notifier.NotificationSubsystem;
import pedersen.systems.notifier.OnGameOver;
import pedersen.team.communication.CommuniqueEnemyScan;
import pedersen.team.communication.CommuniquePersonalData;

public class Controller
extends DebuggableBase
implements OnGameOver {
    private static final Controller singleton = new Controller();
    private Graphics2D console = null;
    private static long turnsProcessed = 0L;

    private Controller() {
        NotificationSubsystem.getInstance().subscribeOnGameOver(this);
    }

    public static Controller getInstance() {
        return singleton;
    }

    private void battleSetup() {
        GameState.getInstance().nextPersistentRandom();
        Persistence.setDataDirectory(Foundation.getInstance().getDataDirectory());
        Teammate.add(Foundation.getInstance().getTeammates());
    }

    public void roundSetup() {
        if (GameState.getInstance().isFirstRound()) {
            this.battleSetup();
        }
    }

    public void processTurn() {
        Metrics.getInstance().incrementTurnCount();
        TargetBank.getInstance().detectShotFired();
        CombatWaveBank.getInstance().process();
        Combatant.getCombatant().operate(GameState.getInstance().getTurn());
        Vehicle fp = Instructions.getInstance().getChassisFuturePosition();
        if (fp == null) {
            fp = GameState.getInstance().getChassis();
        }
        CommunicationSubsystem.getInstance().prepareCommunique(new CommuniquePersonalData(GameState.getInstance().getTurnAfter(), fp.getPosition().getX(), fp.getPosition().getY(), fp.getDirection().getAbsoluteRadians(), fp.getVelocity().velocity(), GameState.getInstance().getSnapshot().getEnergy().energy()));
        CommunicationSubsystem.getInstance().turnTeardown();
        NotificationSubsystem.getInstance().publishOnPaint();
        GraphicalDebugger.onPaint(this.console);
        this.console = null;
        ++turnsProcessed;
    }

    private void roundTeardown() {
        Metrics.getInstance().place(GameState.getInstance().getActiveEnemyCount());
    }

    public void processRobotSnapshot(long time, String name, Snapshot snapshot, boolean personalScan) {
        Target vaultEntry = TargetBank.getInstance().findOrCreateByName(name);
        if (vaultEntry != null) {
            vaultEntry.update(snapshot);
            Combatant.getCombatant().scan(vaultEntry);
            if (personalScan) {
                CommuniqueEnemyScan es = new CommuniqueEnemyScan(snapshot.getTime(), snapshot.getPosition().getX(), snapshot.getPosition().getY(), snapshot.getDirection().getAbsoluteRadians(), snapshot.getVelocity().velocity(), snapshot.getEnergy().energy(), name);
                CommunicationSubsystem.getInstance().prepareCommunique(es);
            }
        }
    }

    public void onPaint(Graphics2D console) {
        this.console = console;
    }

    protected void onWin() {
        this.roundTeardown();
    }

    protected void onDeath() {
        this.roundTeardown();
    }

    @Override
    public void teardown() {
        this.debug();
        this.console("\n\n\n");
        this.console(this.description());
        this.console("\n\n\n");
        this.console("CompetitorBase.counter = " + Competitor.CompetitorBase.counter);
        this.console("SnapshotImpl.counter = " + SnapshotImpl.counter);
        this.console("SnapshotImpl.release = " + SnapshotImpl.release);
        this.console("BaseCombatWave.counter = " + BaseCombatWave.counter);
        this.console("BaseCombatWave.release = " + BaseCombatWave.release);
        this.console("TargetAnalysis.counter = " + TargetAnalysis.counter);
        this.console("TargetAnalysis.release = " + TargetAnalysis.release);
        this.console("FiringSolution.counter = " + FiringSolution.counter);
        this.console("FiringSolution.release = " + FiringSolution.release);
    }

    @Override
    public String description() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getCanonicalName());
        buffer.append("\n").append(Metrics.getInstance().description());
        buffer.append("\n").append(EventProcessor.getStats());
        buffer.append("\n").append(TargetFactory.singleton.description());
        buffer.append("\n").append(TargetBank.getInstance().description());
        buffer.append("\n").append(CombatWaveBank.getInstance().description());
        buffer.append("\n").append(ScannerSubsystem.getInstance().description());
        buffer.append("\n").append(TurretSubsystem.getInstance().description());
        buffer.append("\n").append(CommunicationSubsystem.getInstance().description());
        buffer.append("\n").append("Average time per turn: " + Stopwatches.combatantOperate.getElapsedTime() / turnsProcessed);
        buffer.append("\n").append(Stopwatches.singleton.description());
        return buffer.toString();
    }
}

