/*
 * Decompiled with CFR 0.152.
 */
package sqTank.neuralib;

import java.io.Serializable;
import sqTank.neuralib.NeuronLayer;

public class NeuralNetwork
implements Serializable {
    public NeuronLayer[] layers;
    public int index = 0;
    public boolean loadNN = false;

    public NeuralNetwork(int[] network) {
        this.layers = new NeuronLayer[network.length - 1];
        int i = 0;
        while (i < this.layers.length) {
            this.layers[i] = new NeuronLayer(network[i], network[i + 1]);
            ++i;
        }
    }

    public double[] forwardPass(double[] input) {
        int i = 0;
        while (i < this.layers.length) {
            if (this.layers[i] == null) {
                System.out.println("NULL");
            }
            input = this.layers[i].getOutput(input);
            ++i;
        }
        return input;
    }

    double[][] transform(double[] weights, int layerPth) {
        int xSize = this.layers[layerPth].getInputSize() + 1;
        int ySize = this.layers[layerPth].getOutputSize();
        double[][] retval = new double[xSize][ySize];
        int i = 0;
        while (i < retval.length) {
            int j = 0;
            while (j < retval[i].length) {
                retval[i][j] = weights[this.index];
                ++this.index;
                ++j;
            }
            ++i;
        }
        return retval;
    }

    public void setWeigth(double[] weights) {
        int layerNum = this.layers.length;
        boolean index = false;
        int i = 0;
        while (i < this.layers.length) {
            double[][] layerWeight = this.transform(weights, i);
            this.layers[i].setWeight(layerWeight);
            ++i;
        }
    }

    public void train(double[] input, double[] output) {
        double[] out = this.forwardPass(input);
        double error = 0.0;
        input = this.forwardPass(input);
        int i = 0;
        while (i < input.length) {
            error += output[i] - out[i];
            out[i] = (output[i] - out[i]) * out[i] * (1.0 - out[i]);
            input[i] = (output[i] - input[i]) * input[i] * (1.0 - input[i]);
            ++i;
        }
        i = this.layers.length - 1;
        while (i > -1) {
            input = this.layers[i].propagate(input);
            --i;
        }
    }

    public void init() {
        int i = 0;
        while (i < this.layers.length) {
            this.layers[i].init();
            ++i;
        }
    }
}

