/*
 * Decompiled with CFR 0.152.
 */
package et;

import et.Location;
import et.Predator;

class IncomingFire
extends Location {
    private Location origin;
    private long timeFired;
    private long timeToHit;
    private double heading;
    private double power;
    private double velocity;

    public IncomingFire(Location location, long l, double d, Predator predator) {
        this.origin = location;
        this.timeFired = l;
        this.power = d;
        this.velocity = 20.0 - 3.0 * d;
        double d2 = location.distance(predator.getPosition()) / this.velocity;
        double d3 = predator.getX() + predator.getAvgVelocity() * d2 * Math.sin(Math.toRadians(predator.getHeading()));
        double d4 = predator.getY() + predator.getAvgVelocity() * d2 * Math.cos(Math.toRadians(predator.getHeading()));
        this.setLocation(d3, d4);
    }

    public void update(long l) {
        this.timeToHit = (long)(this.distance(this.origin) / this.velocity - (double)(l - this.timeFired));
    }

    public long getTimeToHit() {
        return this.timeToHit;
    }

    public double getPower() {
        return this.power;
    }
}

