/*
 * Decompiled with CFR 0.152.
 */
package spin;

public class MathVector {
    private double x;
    private double y;

    public MathVector() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public MathVector(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public MathVector(MathVector a) {
        this.x = a.getX();
        this.y = a.getY();
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setCoords(MathVector newCoords) {
        this.x = newCoords.getX();
        this.y = newCoords.getY();
    }

    public double lenght() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double getAngle() {
        return Math.atan2(this.x, this.y);
    }

    public void normalize() {
        this.x /= this.lenght();
        this.y /= this.lenght();
    }

    public MathVector add(MathVector b) {
        return new MathVector(this.x + b.getX(), this.y + b.getY());
    }

    public MathVector sub(MathVector b) {
        return new MathVector(this.x - b.getX(), this.y - b.getY());
    }

    public MathVector mul(double a) {
        return new MathVector(this.x * a, this.y * a);
    }

    public MathVector div(double a) {
        return new MathVector(this.x / a, this.y / a);
    }

    public String toString() {
        return "mathVector [" + this.x + ", " + this.y + "]";
    }

    public MathVector neg() {
        return new MathVector(-this.x, -this.y);
    }

    public MathVector norm() {
        return new MathVector(this.x / this.lenght(), this.y / this.lenght());
    }

    public MathVector getLeftNormal() {
        return new MathVector(-this.y, this.x).norm();
    }

    public MathVector rotate(double d) {
        return new MathVector(this.x * Math.cos(d) - this.y * Math.sin(d), this.x * Math.sin(d) + this.y * Math.cos(d));
    }

    public MathVector limitLenghtTo(double d) {
        if (this.lenght() > d) {
            return this.norm().mul(d);
        }
        return new MathVector(this.x, this.y);
    }

    public double sinA(MathVector b) {
        return (this.getX() * b.getY() - this.getY() * b.getX()) / (this.lenght() * b.lenght());
    }

    public double scalarMul(MathVector b) {
        return this.getX() * b.getX() + this.getY() * b.getY();
    }

    public MathVector limitToSquare(double w, double h) {
        double a = 30.0;
        MathVector ret = new MathVector(this);
        if (ret.getX() < a) {
            ret.setX(a);
        } else if (ret.getX() > w - a) {
            ret.setX(w - a);
        }
        if (ret.getY() < a) {
            ret.setY(a);
        } else if (ret.getY() > h - a) {
            ret.setY(h - a);
        }
        return ret;
    }

    public static MathVector min(MathVector a, MathVector b) {
        if (a.lenght() > b.lenght()) {
            return b;
        }
        return a;
    }

    public static MathVector max(MathVector a, MathVector b) {
        if (a.lenght() < b.lenght()) {
            return b;
        }
        return a;
    }
}

