/*
 * Decompiled with CFR 0.152.
 */
package syl;

import java.awt.Color;
import robocode.DeathEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;
import syl.core.BaseRobot;
import syl.core.Enemy;
import syl.fire.FireStrategy;
import syl.fire.FireStrategyManager;
import syl.movement.MovementStrategy;
import syl.movement.MovementStrategyManager;
import syl.scan.ScanStrategy;
import syl.scan.ScanStrategyManager;
import syl.target.TargetPickerStrategy;
import syl.target.TargetPickerStrategyManager;
import syl.util.Log;

public class Centipede
extends BaseRobot {
    private ScanStrategyManager scanStrategyManager = new ScanStrategyManager(this);
    private TargetPickerStrategyManager targetPickerStrategyManager = new TargetPickerStrategyManager(this);
    private MovementStrategyManager movementStrategyManager = new MovementStrategyManager(this);
    private FireStrategyManager fireStrategyManager = new FireStrategyManager(this);
    private boolean hasFired;

    public void doInitialize() {
        Color base = new Color(255, 255, 15);
        Color turret = new Color(255, 255, 15);
        Color radar = new Color(255, 255, 15);
        this.setColors(base, turret, radar);
        this.scanStrategyManager.initialize();
        this.targetPickerStrategyManager.initialize();
        this.movementStrategyManager.initialize();
        this.fireStrategyManager.initialize();
    }

    public void performAction() {
        ScanStrategy scanStrategy = this.scanStrategyManager.getScanStrategy();
        scanStrategy.doScan();
        TargetPickerStrategy targetPickerStrategy = this.targetPickerStrategyManager.getTargetPickerStrategy();
        Enemy enemy = targetPickerStrategy.getCurrentTarget();
        if (enemy == null) {
            enemy = targetPickerStrategy.getTarget();
        } else if (this.hasFired) {
            enemy = targetPickerStrategy.getTarget();
        }
        MovementStrategy movementStrategy = this.movementStrategyManager.getMovementStrategy();
        movementStrategy.doMovement(enemy);
        FireStrategy fireStrategy = this.fireStrategyManager.getFireStrategy(enemy);
        if (fireStrategy != null) {
            this.hasFired = this.fireStrategyManager.doFire(enemy);
        }
    }

    public void onDeath(DeathEvent arg0) {
        this.cleanUp();
        super.onDeath(arg0);
    }

    public void onWin(WinEvent arg0) {
        this.cleanUp();
        super.onWin(arg0);
    }

    public void onSkippedTurn(SkippedTurnEvent skippedturnevent) {
        Log.log((Object)this, true, "Turn skip!!!!!!");
    }

    private void cleanUp() {
        this.scanStrategyManager.cleanUp();
        this.targetPickerStrategyManager.cleanUp();
        this.movementStrategyManager.cleanUp();
        this.fireStrategyManager.cleanUp();
    }
}

