/*
 * Decompiled with CFR 0.152.
 */
package syl.fire;

import java.util.ArrayList;
import syl.fire.VirtualBullet;
import syl.fire.VirtualBulletMap;

public class HitRatioManager {
    private VirtualBulletMap trackingBulletMap = new VirtualBulletMap();
    private ArrayList numberOfMisses = new ArrayList();
    private ArrayList numberOfHits = new ArrayList();
    private static final int MEMORY_AGE = 300;

    public void addTrackingBullet(VirtualBullet trackingBullet) {
        this.trackingBulletMap.addTrackingBullet(trackingBullet);
    }

    public void updateHitRatio(long time) {
        int i = this.trackingBulletMap.getNumberOfTrackingBullets() - 1;
        while (i >= 0) {
            VirtualBullet trackingBullet = this.trackingBulletMap.getTrackingBullet(i);
            this.removeIfMissed(time, trackingBullet);
            if (trackingBullet.hasHit(time)) {
                this.numberOfHits.add(new Long(time));
                this.trackingBulletMap.removeTrackingBullet(trackingBullet);
            }
            --i;
        }
        this.cleanUp(time);
    }

    public double getCurrentHitRatio() {
        if (this.numberOfHits.size() + this.numberOfMisses.size() == 0) {
            return 0.0;
        }
        return 100.0 * ((double)this.numberOfHits.size() / ((double)this.numberOfHits.size() + (double)this.numberOfMisses.size()));
    }

    public void removeIfMissed(long time, VirtualBullet trackingBullet) {
        if (trackingBullet.hasMissed(time)) {
            this.numberOfMisses.add(new Long(time));
            this.trackingBulletMap.removeTrackingBullet(trackingBullet);
        }
    }

    private void cleanUp(long time) {
        int i = this.numberOfMisses.size() - 1;
        while (i > -1) {
            if (time - (Long)this.numberOfMisses.get(i) > 300L) {
                this.numberOfMisses.remove(i);
            }
            --i;
        }
        i = this.numberOfHits.size() - 1;
        while (i > -1) {
            if (time - (Long)this.numberOfHits.get(i) > 300L) {
                this.numberOfHits.remove(i);
            }
            --i;
        }
    }
}

