/*
 * Decompiled with CFR 0.152.
 */
package mb.waves;

import java.util.ArrayList;
import java.util.List;
import mb.MBRobot;
import mb.core.Coordinates;
import mb.core.Corner;
import mb.utils.MathUtils;
import mb.waves.Segments;
import mb.waves.Wave;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;

public class WaveStorage {
    private List<Wave> waves = new ArrayList<Wave>();
    private double xMax;
    private double yMax;
    private static ArrayList<Coordinates>[][][][][] diffVector = new ArrayList[Segments.headingSegments + 1][Segments.distanceSegments + 1][Segments.velocitySegments + 1][Segments.velocitySegments + 1][Segments.cornerSegments];
    private static boolean isInitiliazed = false;
    private static long waveCount = 0L;

    public WaveStorage(MBRobot robot) {
        this.xMax = robot.getBattleFieldWidth();
        this.yMax = robot.getBattleFieldHeight();
        if (!isInitiliazed) {
            int i = 0;
            while (i < diffVector.length) {
                int j = 0;
                while (j < diffVector[i].length) {
                    int k = 0;
                    while (k < diffVector[i][j].length) {
                        int l = 0;
                        while (l < diffVector[i][j][k].length) {
                            int m = 0;
                            while (m < diffVector[i][j][k][l].length) {
                                WaveStorage.diffVector[i][j][k][l][m] = new ArrayList();
                                ++m;
                            }
                            ++l;
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        isInitiliazed = true;
    }

    public void newWave(long fireTime, double power, Coordinates start, Coordinates target, ScannedRobotEvent event, AdvancedRobot me) {
        Segments segment = new Segments();
        segment.distance = event.getDistance();
        segment.heading = me.getGunHeading();
        segment.velocity = event.getVelocity();
        segment.lateralVelocity = this.getLateralVelocity(event, me.getHeadingRadians());
        segment.corner = this.isInCorner(target);
        Wave wave = new Wave(fireTime, power, start, target, segment, me.getGunHeading());
        this.waves.add(wave);
        ++waveCount;
    }

    public void checkWaves(Coordinates enemyPosition, long currentTime) {
        int i = 0;
        while (i < this.waves.size()) {
            Wave currentWave = this.waves.get(i);
            if (currentWave.checkHit(enemyPosition, currentTime)) {
                Segments segment = currentWave.getSegment();
                Coordinates diff = currentWave.getDiffVector(enemyPosition);
                diffVector[this.getHeadingSegment(segment.heading)][this.getDistanceSegment(segment.distance)][this.getVelocitySegement(segment.velocity)][this.getVelocitySegement(segment.lateralVelocity)][segment.corner.ordinal()].add(diff);
                this.waves.remove(currentWave);
                --i;
            }
            ++i;
        }
    }

    public List<Coordinates> getDiffVectors(ScannedRobotEvent event, MBRobot me) {
        double heading = me.getGunHeading();
        double distance = event.getDistance();
        double velocity = event.getVelocity();
        double lateralVelocity = this.getLateralVelocity(event, me.getHeadingRadians());
        Coordinates enemyPos = MathUtils.getEnemyCoordinates(me.getMyCoordinates(), me.getHeading(), event.getBearing(), event.getDistance());
        Corner corner = this.isInCorner(enemyPos);
        return diffVector[this.getHeadingSegment(heading)][this.getDistanceSegment(distance)][this.getVelocitySegement(velocity)][this.getVelocitySegement(lateralVelocity)][corner.ordinal()];
    }

    private int getHeadingSegment(double heading) {
        return (int)heading / (360 / Segments.headingSegments);
    }

    private int getDistanceSegment(double distance) {
        return (int)distance / (1200 / Segments.distanceSegments);
    }

    private int getVelocitySegement(double velocity) {
        return (int)((velocity + 8.0) * (double)Segments.velocitySegments / 16.0);
    }

    private double getLateralVelocity(ScannedRobotEvent event, double headingRadians) {
        double enemyAbsoluteBearing = event.getBearingRadians() + headingRadians;
        return event.getVelocity() * Math.sin(event.getHeadingRadians() - enemyAbsoluteBearing);
    }

    private Corner isInCorner(Coordinates pos) {
        int cornerDistance = 100;
        if (pos.getX() < (double)cornerDistance && pos.getY() < (double)cornerDistance) {
            return Corner.LOWERLEFT;
        }
        if (pos.getX() < (double)cornerDistance && pos.getY() > this.yMax - (double)cornerDistance) {
            return Corner.UPPERLEFT;
        }
        if (pos.getX() > this.xMax - (double)cornerDistance && pos.getY() < (double)cornerDistance) {
            return Corner.LOWERRIGHT;
        }
        if (pos.getX() > this.xMax - (double)cornerDistance && pos.getY() > this.yMax - (double)cornerDistance) {
            return Corner.UPPERRIGHT;
        }
        return Corner.NONE;
    }
}

