/*
 * Decompiled with CFR 0.152.
 */
package techdude.kombat;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.MessageEvent;
import robocode.MoveCompleteCondition;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.TeamRobot;
import robocode.util.Utils;
import techdude.kombat.Enemy;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FlamingKombat
extends TeamRobot {
    static final double MAX_VELOCITY = 8.0;
    static final double WALL_MARGIN = 25.0;
    Point2D robotLocation;
    Point2D enemyLocation;
    double enemyDistance;
    double enemyAbsoluteBearing;
    double movementLateralAngle;
    int mode;
    int secmode;
    int seccount;
    int teammode;
    Enemy target;
    final double PI = Math.PI;
    int direction;
    double firePower;

    public void run() {
        this.target = new Enemy();
        this.target.distance = 100000.0;
        this.setColors(Color.green, Color.green, Color.green);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.turnRadarRightRadians(Math.PI * 2);
        while (true) {
            this.setTurnRadarRightRadians(Math.PI * 2);
            this.goTo(new Point2D.Double(10.0, 10.0));
            this.waitFor((Condition)new MoveCompleteCondition((AdvancedRobot)this));
            this.goTo(new Point2D.Double(10.0, 10.0));
            this.waitFor((Condition)new MoveCompleteCondition((AdvancedRobot)this));
            this.goTo(new Point2D.Double(10.0, 10.0));
            this.waitFor((Condition)new MoveCompleteCondition((AdvancedRobot)this));
            this.goTo(new Point2D.Double(10.0, 10.0));
            this.waitFor((Condition)new MoveCompleteCondition((AdvancedRobot)this));
        }
    }

    void move() {
        this.considerChangingDirection();
        Point2D robotDestination = null;
        double tries = 0.0;
        do {
            robotDestination = FlamingKombat.vectorToLocation(FlamingKombat.absoluteBearing(this.enemyLocation, this.robotLocation) + this.movementLateralAngle, this.enemyDistance * (1.1 - tries / 100.0), this.enemyLocation);
        } while ((tries += 1.0) < 100.0 && !this.fieldRectangle(25.0).contains(robotDestination));
        this.goTo(robotDestination);
    }

    public void onMessageRecieved(MessageEvent e) {
        this.teammode = 1;
    }

    void considerChangingDirection() {
        double flattenerFactor = 0.05;
        if (Math.random() < flattenerFactor) {
            this.movementLateralAngle *= -1.0;
        }
    }

    RoundRectangle2D fieldRectangle(double margin) {
        return new RoundRectangle2D.Double(margin, margin, this.getBattleFieldWidth() - margin * (double)2, this.getBattleFieldHeight() - margin * (double)2, 75.0, 75.0);
    }

    void goTo(Point2D destination) {
        double angle = Utils.normalRelativeAngle((double)(FlamingKombat.absoluteBearing(this.robotLocation, destination) - this.getHeadingRadians()));
        double turnAngle = Math.atan(Math.tan(angle));
        this.setTurnRightRadians(turnAngle);
        this.setAhead(this.robotLocation.distance(destination) * (double)(angle == turnAngle ? 1 : -1));
    }

    static Point2D vectorToLocation(double angle, double length, Point2D sourceLocation) {
        return FlamingKombat.vectorToLocation(angle, length, sourceLocation, new Point2D.Double());
    }

    static Point2D vectorToLocation(double angle, double length, Point2D sourceLocation, Point2D targetLocation) {
        targetLocation.setLocation(sourceLocation.getX() + Math.sin(angle) * length, sourceLocation.getY() + Math.cos(angle) * length);
        return targetLocation;
    }

    static double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }

    void doFirePower() {
        this.firePower = 400.0 / this.target.distance;
    }

    void doScanner() {
        double radarOffset;
        radarOffset = this.getTime() - this.target.ctime > (long)4 ? 360.0 : ((radarOffset = this.getRadarHeadingRadians() - this.absbearing(this.getX(), this.getY(), this.target.x, this.target.y)) < 0.0 ? (radarOffset -= 0.39269908169872414) : (radarOffset += 0.39269908169872414));
        this.setTurnRadarLeftRadians(this.NormaliseBearing(radarOffset));
    }

    void doGun() {
        long time = this.getTime() + (long)((int)(this.target.distance / (20.0 - (double)3 * this.firePower)));
        double gunOffset = this.mode == 0 || Math.random() < 0.5 ? this.getGunHeadingRadians() - this.absbearing(this.getX(), this.getY(), this.target.guessX(time), this.target.guessY(time)) : this.getGunHeadingRadians() - this.absbearing(this.getX(), this.getY(), this.target.x, this.target.y);
        this.setTurnGunLeftRadians(this.NormaliseBearing(gunOffset));
    }

    double NormaliseBearing(double ang) {
        if (ang > Math.PI) {
            ang -= Math.PI * 2;
        }
        if (ang < -Math.PI) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    double NormaliseHeading(double ang) {
        if (ang > Math.PI * 2) {
            ang -= Math.PI * 2;
        }
        if (ang < 0.0) {
            ang += Math.PI * 2;
        }
        return ang;
    }

    public double getrange(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Math.sqrt(xo * xo + yo * yo);
        return h;
    }

    public double absbearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = this.getrange(x1, y1, x2, y2);
        if (xo > 0.0 && yo > 0.0) {
            return Math.asin(xo / h);
        }
        if (xo > 0.0 && yo < 0.0) {
            return Math.PI - Math.asin(xo / h);
        }
        if (xo < 0.0 && yo < 0.0) {
            return Math.PI + Math.asin(-xo / h);
        }
        if (xo < 0.0 && yo > 0.0) {
            return Math.PI * 2 - Math.asin(-xo / h);
        }
        return 0.0;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        if ((e.getDistance() < this.target.distance || this.target.name == e.getName()) && !this.isTeammate(e.getName())) {
            double absbearing_rad = (this.getHeadingRadians() + e.getBearingRadians()) % (Math.PI * 2);
            this.target.name = e.getName();
            this.target.x = this.getX() + Math.sin(absbearing_rad) * e.getDistance();
            this.target.y = this.getY() + Math.cos(absbearing_rad) * e.getDistance();
            this.target.bearing = e.getBearingRadians();
            this.target.head = e.getHeadingRadians();
            this.target.ctime = this.getTime();
            this.target.speed = e.getVelocity();
            this.target.distance = e.getDistance();
            this.robotLocation = new Point2D.Double(this.getX(), this.getY());
            this.enemyAbsoluteBearing = this.getHeadingRadians() + e.getBearingRadians();
            this.enemyDistance = e.getDistance();
            this.enemyLocation = FlamingKombat.vectorToLocation(this.enemyAbsoluteBearing, this.enemyDistance, this.robotLocation);
        }
        if (this.teammode == 0) {
            if (this.getOthers() > 4) {
                this.mode = 1;
            }
            if (this.getOthers() < 4) {
                this.mode = 0;
            }
        }
        if (this.mode == 1) {
            this.move();
        }
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(this.enemyAbsoluteBearing - this.getRadarHeadingRadians())) * (double)2);
        this.doFirePower();
        this.doScanner();
        this.doGun();
        this.out.println(this.target.distance);
        this.setFire(this.firePower);
        if (this.mode == 0) {
            if (this.secmode == 1) {
                if (this.getTime() % 20L == 0L) {
                    this.direction *= -1;
                    this.setAhead(this.direction * 300);
                }
                ++this.seccount;
                this.setTurnRightRadians(this.target.bearing + 1.5707963267948966);
            } else {
                this.setTurnRight(10000.0);
                this.setMaxVelocity(5);
                this.setAhead(10000.0);
                ++this.seccount;
            }
        }
        if (this.seccount > 500) {
            this.seccount = 0;
            int n = 0;
            if (this.secmode == 1) {
                n = 1;
            }
            this.secmode = 1 - n;
        }
        if (this.mode == 1) {
            this.setTurnRadarRightRadians(Math.PI * 2);
        }
        this.execute();
    }

    public void onRobotDeath(RobotDeathEvent e) {
        if (e.getName() == this.target.name) {
            this.target.distance = 1.0E7;
        }
    }

    private final /* synthetic */ void this() {
        this.robotLocation = new Point2D.Double(0.0, 0.0);
        this.enemyLocation = new Point2D.Double(0.0, 0.0);
        this.movementLateralAngle = 0.2;
        this.mode = 1;
        this.secmode = 0;
        this.seccount = 0;
        this.teammode = 0;
        this.PI = Math.PI;
        this.direction = 1;
    }

    public FlamingKombat() {
        this.this();
    }
}

