/*
 * Decompiled with CFR 0.152.
 */
package rjw.gun;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.ListIterator;
import rjw.AbstractComponent;
import rjw.Memory;
import rjw.Props;
import rjw.RabidWombat;
import rjw.gun.CircularGun;
import rjw.gun.GuessFactorGun;
import rjw.gun.Gun;
import rjw.gun.GunData;
import rjw.gun.GunWave;
import rjw.gun.HeadOnGun;
import rjw.gun.LinearGun;
import rjw.pluggablerobot.Canvas;
import rjw.pluggablerobot.Hud;
import rjw.pluggablerobot.Math2;
import rjw.radar.Enemy;
import rjw.radar.EnemyScan;
import rjw.util.DecayBins;
import rjw.util.Particle;
import robocode.util.Utils;

public class Turret
extends AbstractComponent
implements Hud.Painter {
    private static final Color METER_BACKGROUND_COLOR = new Color(0, 0, 0, 128);
    private static final int STATS_DECAY = 500;
    private static final Class<?>[] GUN_CLASSES = new Class[]{HeadOnGun.class, LinearGun.class, CircularGun.class, GuessFactorGun.class};
    public static Gun[] _guns = new Gun[GUN_CLASSES.length];
    public static DecayBins _bins = new DecayBins(GUN_CLASSES.length, 500, 0);
    public static int _bestGunIndex = 0;
    private static double _botHalfWidth = 0.0;
    private static double _botHalfHeight = 0.0;
    private final double MAX_BULLET_POWER;
    private final boolean FAVOR_ENERGY_OVER_BULLETS;
    private GunData[] _gunData = new GunData[GUN_CLASSES.length];
    private double _fireAngle = 0.0;
    private long _lastTick = -1L;
    private ArrayList<GunWave> _waves = new ArrayList();
    private double _waveHitRadiusRange;

    static {
        int i = 0;
        while (i < GUN_CLASSES.length) {
            try {
                Turret._guns[i] = (Gun)GUN_CLASSES[i].newInstance();
                _guns[i].setIndex(i);
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            ++i;
        }
    }

    public Turret(RabidWombat bot) {
        super(bot);
        Props p = RabidWombat.getProps();
        this.MAX_BULLET_POWER = p.getDouble("gun.maxBulletPower", 3.0);
        this.FAVOR_ENERGY_OVER_BULLETS = p.getBoolean("gun.favorEnergyOverBullets", false);
        this._waveHitRadiusRange = Math.sqrt(Math.pow(bot.getWidth(), 2.0) + Math.pow(bot.getHeight(), 2.0)) / 2.0;
        if (_botHalfWidth == 0.0) {
            _botHalfWidth = bot.getWidth() / 2.0;
            _botHalfHeight = bot.getHeight() / 2.0;
        }
        int i = 0;
        while (i < GUN_CLASSES.length) {
            _guns[i].setBot(bot);
            ++i;
        }
    }

    @Override
    public void go() {
        RabidWombat bot = this.getBot();
        if (bot.getOthers() == 0) {
            return;
        }
        Enemy target = this.getMemory().getTarget();
        if (target == null) {
            return;
        }
        EnemyScan currentScan = target.get(0);
        long tick = bot.getTime();
        if (currentScan.getTick() != tick) {
            return;
        }
        if (currentScan.getEnergy() < 0.1) {
            return;
        }
        Particle me = bot.getParticle();
        double currentEnemyBearing = me.getAbsoluteTargetBearing(currentScan);
        boolean wavesDied = false;
        ListIterator<GunWave> iter = this._waves.listIterator();
        while (iter.hasNext()) {
            GunWave wave = iter.next();
            double targetDistance = wave.getOrigin().distance(currentScan.p());
            double minHitDistance = targetDistance - this._waveHitRadiusRange;
            double maxHitDistance = targetDistance + this._waveHitRadiusRange;
            double radius = wave.radius(tick);
            if (radius > targetDistance && wave.getCorrectAngle() == null) {
                wave.setCorrectAngle(currentEnemyBearing);
            }
            if (radius > maxHitDistance) {
                wavesDied = true;
                double correctAngle = wave.getCorrectAngle();
                int i = 0;
                while (i < _guns.length) {
                    if (wave.getGunData(i).isHit()) {
                        _bins.put(i);
                    } else {
                        _guns[i].notifyMiss(wave, correctAngle);
                    }
                    ++i;
                }
                iter.remove();
                _bins.endTick();
                continue;
            }
            if (!(radius >= minHitDistance)) continue;
            int i = 0;
            while (i < _guns.length) {
                Point2D.Double pos;
                if (!wave.getGunData(i).isHit() && Turret.hit(currentScan, pos = wave.getBulletPosition(i, tick))) {
                    wave.getGunData(i).hit();
                    _guns[i].notifyHit(wave);
                }
                ++i;
            }
        }
        if (wavesDied) {
            _bins.endTick();
        }
        _bestGunIndex = _bins.maxBindex();
        double power = Math.min(Math2.damageToFirePower(currentScan.getEnergy()), this.MAX_BULLET_POWER);
        this.calculateGunAngles(tick);
        GunWave wave = new GunWave(target.getName(), me.p(), tick, this._gunData, power);
        if (this._fireAngle >= 0.0) {
            boolean shoot;
            boolean bl = shoot = bot.getEnergy() - power >= 0.1 && !(bot.getGunHeat() > 0.0);
            if (this.FAVOR_ENERGY_OVER_BULLETS && shoot) {
                double enemyEnergy;
                double myEnergy = bot.getEnergy();
                boolean bl2 = shoot = myEnergy < (enemyEnergy = currentScan.getEnergy()) || myEnergy - power > enemyEnergy;
            }
            if (shoot) {
                bot.setBulletColor(_guns[_bestGunIndex].getColor());
                bot.setFire(power);
                this._waves.add(wave);
            }
            double diff = Utils.normalRelativeAngle((double)(this._fireAngle - bot.getGunHeadingRadians()));
            bot.setTurnGunRightRadians(diff);
        }
    }

    @Override
    public void paint(Canvas canvas, long tick) {
        Enemy target = this.getMemory().getTarget();
        EnemyScan currentScan = target == null ? null : target.get(0);
        for (GunWave wave : this._waves) {
            canvas.setPaint(Color.BLUE);
            canvas.drawCircle(wave.getOrigin().x, wave.getOrigin().y, wave.radius(tick));
        }
        int i = 0;
        while (i < _guns.length) {
            Gun gun = _guns[i];
            if (gun instanceof Hud.Painter) {
                ((Hud.Painter)((Object)gun)).paint(canvas, tick);
            }
            boolean isBest = _bestGunIndex == i;
            double hitPerc = _bins.size() != 0 ? _bins.bin(i) / _bins.maxPossibleValue() : 0.0;
            String gunName = gun.getClass().getSimpleName();
            RabidWombat bot = this.getBot();
            double y = bot.getBattleFieldHeight() - (double)((i + 1) * 10);
            canvas.setPaint(METER_BACKGROUND_COLOR);
            canvas.fillRect(5.0, y, 100.0, 7.0);
            canvas.setPaint(gun.getColor());
            if (isBest) {
                canvas.drawRect(5.0, y + 1.0, 99.0, 6.0);
            }
            canvas.drawString(gunName, 108.0, y);
            canvas.fillRect(5.0, y, hitPerc * 100.0, 7.0);
            if (bot.getOthers() != 0 && currentScan != null) {
                this.calculateGunAngles(tick);
                for (GunWave wave : this._waves) {
                    Point2D.Double prev = wave.getBulletPosition(i, tick - 1L);
                    Point2D.Double next = wave.getBulletPosition(i, tick + 1L);
                    canvas.drawLine(prev.x, prev.y, next.x, next.y);
                    Point2D.Double pos = wave.getBulletPosition(i, tick);
                    if (!Turret.hit(currentScan, pos)) continue;
                    canvas.fillRect(pos.x - 3.0, pos.y - 3.0, 7.0, 7.0);
                }
            }
            ++i;
        }
    }

    private void calculateGunAngles(long tick) {
        if (tick == this._lastTick) {
            return;
        }
        this._lastTick = tick;
        this._gunData = new GunData[GUN_CLASSES.length];
        this._fireAngle = -1.0;
        RabidWombat bot = this.getBot();
        if (bot.getOthers() == 0) {
            return;
        }
        if (bot.getEnergy() < 0.1) {
            return;
        }
        Enemy target = this.getMemory().getTarget();
        if (target == null) {
            return;
        }
        EnemyScan currentScan = target.get(0);
        double power = Math2.damageToFirePower(currentScan.getEnergy());
        int i = 0;
        while (i < _guns.length) {
            GunData d;
            this._gunData[i] = d = _guns[i].fire(power);
            if (i == _bestGunIndex && d.getFireAngle() != null) {
                this._fireAngle = d.getFireAngle();
            }
            ++i;
        }
    }

    private static boolean hit(EnemyScan enemy, Point2D.Double bullet) {
        Point2D.Double pos = enemy.p();
        double min = pos.x - _botHalfWidth;
        double max = pos.x + _botHalfWidth;
        if (bullet.x < min || bullet.x > max) {
            return false;
        }
        min = pos.y - _botHalfHeight;
        max = pos.y + _botHalfHeight;
        return !(bullet.y < min) && !(bullet.y > max);
    }

    private Memory getMemory() {
        return this.getBot().getMemory();
    }
}

