/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import java.text.NumberFormat;
import shrub.GunInstruction;
import shrub.Heading;
import shrub.LinearPredictor;
import shrub.Location;
import shrub.Sighting;

public class Gun {
    private int mMode = 0;
    private long mTime = 0L;
    private double mGunHeat = 0.0;
    private double mCoolingRate = 0.1;
    private Location mGunLocn = new Location();
    private Heading mGunHdng = new Heading();
    private Sighting mTargetInfo = new Sighting();
    private double mMaxPower = 3.0;
    private double mMinPower = 0.1;
    private NumberFormat dp2 = NumberFormat.getInstance();

    public void Initialise() {
        this.SetMode(0);
        this.mGunLocn.Initialise();
        this.mGunHdng.Initialise();
        this.mTime = 0L;
        this.mGunHeat = 0.0;
        this.mTargetInfo = null;
        this.mCoolingRate = 0.1;
        this.mMaxPower = 3.0;
        this.mMinPower = 0.1;
        this.dp2.setMaximumFractionDigits(2);
        this.dp2.setMinimumFractionDigits(2);
    }

    public void SetMode(int newMode) {
        this.mMode = newMode;
    }

    public void SetGunHeat(double newGunHeat) {
        this.mGunHeat = newGunHeat;
    }

    public void SetGunHdng(double newGunHdng) {
        this.mGunHdng.Set(newGunHdng);
    }

    public void SetGunLocn(double gunX, double gunY) {
        this.mGunLocn.SetX(gunX);
        this.mGunLocn.SetY(gunY);
    }

    public void SetGunLocn(Location gunLocn) {
        this.mGunLocn.Set(gunLocn);
    }

    public void SetMaxPower(double newMaxPower) {
        this.mMaxPower = newMaxPower;
    }

    public void SetMinPower(double newMinPower) {
        this.mMinPower = newMinPower;
    }

    public void SetTargetInfo(Sighting targetInfo) {
        this.mTargetInfo = targetInfo;
    }

    public void ClearTargetInfo() {
        this.mTargetInfo = null;
    }

    public void SetTime(long newTime) {
        this.mTime = newTime;
    }

    public void SetCoolingRate(double newCoolingRate) {
        this.mCoolingRate = newCoolingRate;
    }

    public boolean IsReadyToFire() {
        boolean answer = false;
        if (this.mGunHeat < 0.01) {
            answer = true;
        }
        return answer;
    }

    public long HowLongTillReady() {
        double numTurns = this.mGunHeat / this.mCoolingRate;
        numTurns = -1.0 * Math.floor(-1.0 * numTurns);
        return (long)numTurns;
    }

    public static final double ShotPowerFromSpeed(double speed) {
        double power = -1.0;
        if (speed >= 0.0) {
            power = (20.0 - speed) / 3.0;
        }
        return power;
    }

    public static final double ShotSpeedFromPower(double power) {
        double speed = -1.0;
        if (power >= 0.0) {
            speed = 20.0 - 3.0 * power;
        }
        return speed;
    }

    public static final double MinLegalPower() {
        return 0.1;
    }

    public static final double MaxLegalPower() {
        return 3.0;
    }

    public GunInstruction Process() {
        GunInstruction instruct = new GunInstruction();
        if (this.mMode == 0) {
            instruct.SetNothing();
        } else if (this.mMode == 1) {
            if (this.IsReadyToFire()) {
                this.Autoshoot(instruct);
            }
        } else {
            System.out.println("ERROR : Gun::Process, unexpected mode");
        }
        return instruct;
    }

    public void Autoshoot(GunInstruction instruct) {
        double maxSpeedAllowed;
        double shotSpeed = 0.0;
        double shotPower = 0.0;
        LinearPredictor predictor = new LinearPredictor();
        double minSpeedAllowed = Gun.ShotSpeedFromPower(this.mMaxPower);
        shotSpeed = predictor.InterceptSpeed(minSpeedAllowed, maxSpeedAllowed = Gun.ShotSpeedFromPower(this.mMinPower), this.mGunLocn, this.mGunHdng, this.mTargetInfo.GetLocation(), this.mTargetInfo.GetHeading(), this.mTargetInfo.GetVelocity());
        shotPower = Gun.ShotPowerFromSpeed(shotSpeed);
        if (shotPower >= 0.05) {
            instruct.SetFire(shotPower);
        } else {
            instruct.SetNothing();
        }
    }

    public void Print() {
        System.out.println("----- Gun -----");
        System.out.println("mMode: " + this.mMode);
        System.out.print("mGunLocn: ");
        this.mGunLocn.Print();
        System.out.println();
        System.out.println("mGunHdng: " + this.mGunHdng.Get());
        if (this.mTargetInfo != null) {
            this.mTargetInfo.Print();
        }
    }

    public Gun() {
        this.Initialise();
    }
}

