/*
 * Decompiled with CFR 0.152.
 */
package gwah;

import java.awt.Color;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class GBotMarkIV
extends AdvancedRobot {
    double trackedBotBearing = 0.0;
    double lastTrackedBotBearing = 0.0;
    double firePower = 0.0;
    long fireTime = 0L;
    long timeToEnemy = 0L;
    double enemyDistance = 0.0;
    double enemyBearing = 0.0;
    double enemyVelocity = 0.0;
    double enemyHeading = 0.0;

    public void run() {
        this.setColors(Color.blue, Color.black, Color.gray);
        this.setScanColor(Color.ORANGE);
        this.setBulletColor(Color.RED);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.setAhead(500.0);
        this.turnRadarRight(Double.POSITIVE_INFINITY);
        while (true) {
            this.scan();
            this.turnRadarRight(Double.POSITIVE_INFINITY);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.enemyDistance = e.getDistance();
        this.enemyBearing = e.getBearingRadians();
        this.enemyVelocity = e.getVelocity();
        this.enemyHeading = e.getHeadingRadians();
        this.setTurnRightRadians(this.enemyBearing);
        this.setRadar(this.enemyBearing);
        this.setGun(this.enemyBearing);
        this.firePower = Math.min(500.0 / this.enemyDistance, 3.0);
        if (this.enemyDistance > 150.0) {
            this.setAhead(100.0);
        } else {
            this.setBack(50.0);
        }
        this.lastTrackedBotBearing = this.enemyBearing;
    }

    public void onHitWall(HitWallEvent e) {
        this.setRadar(this.trackedBotBearing);
        this.setTurnRightRadians(e.getBearing());
        this.back(100.0);
        this.setTurnRadarRight(360.0);
    }

    public void onHitRobot(HitRobotEvent e) {
        double absoluteBearing = this.getGunHeadingRadians() + e.getBearingRadians();
        this.turnGunRightRadians(Utils.normalAbsoluteAngle((double)(absoluteBearing - this.getGunHeading())));
        this.fire(3.0);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.setRadar(this.trackedBotBearing);
        this.setTurnRightRadians(e.getBearingRadians());
        this.setAhead(100.0);
    }

    public void setRadar(Double bearing) {
        double newRadarHeading = this.getHeadingRadians() + bearing - this.getRadarHeadingRadians();
        this.setTurnRadarRightRadians(2.0 * Utils.normalRelativeAngle((double)newRadarHeading));
    }

    public void setGun(Double bearing) {
        double bulletSpeed = 20.0 - this.firePower * 3.0;
        long timeToEnemy = (long)(this.enemyDistance / bulletSpeed);
        double currentX = this.getX();
        double currentY = this.getY();
        double futureY = 0.0;
        double absBearing = Utils.normalAbsoluteAngle((double)(this.getHeadingRadians() + bearing));
        double enemyX = currentX + Math.sin(absBearing) * this.enemyDistance;
        double enemyY = currentY + Math.cos(absBearing) * this.enemyDistance;
        double futureX = enemyX + Math.sin(this.getHeadingRadians()) * this.getVelocity() * (double)timeToEnemy;
        futureY = enemyY + Math.cos(this.getHeadingRadians()) * this.getVelocity() * (double)timeToEnemy;
        double newGunHeading = Utils.normalRelativeAngle((double)(this.absoluteBearing(currentX, currentY, futureX, futureY) - this.getGunHeadingRadians()));
        this.setTurnGunRightRadians(newGunHeading);
        this.checkGun(this.firePower);
    }

    public void checkGun(double bulletPower) {
        if (this.getGunTurnRemaining() < 2.0) {
            this.setFire(bulletPower);
            this.out.println("Bullet Fired! Fire Time: " + this.fireTime);
        }
    }

    double absoluteBearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double hyp = Point2D.distance(x1, y1, x2, y2);
        double arcSin = Math.asin(xo / hyp);
        double bearing = 0.0;
        if (xo > 0.0 && yo > 0.0) {
            bearing = arcSin;
        } else if (xo < 0.0 && yo > 0.0) {
            bearing = Math.PI * 2 + arcSin;
        } else if (xo > 0.0 && yo < 0.0) {
            bearing = Math.PI - arcSin;
        } else if (xo < 0.0 && yo < 0.0) {
            bearing = Math.PI - arcSin;
        }
        return bearing;
    }
}

