/*
 * Decompiled with CFR 0.152.
 */
package execution;

import execution.IDrawable;
import execution.INotifiable;
import execution.Message;
import execution.MessageRouter;
import execution.Painter;
import execution.WaveListener$$Lambda$1;
import execution.WaveListener$$Lambda$2;
import execution.WaveListener$$Lambda$3;
import execution.WaveListener$$Lambda$4;
import execution.WaveListener$$Lambda$5;
import execution.WaveListener$$Lambda$6;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import sim.Bot;
import sim.Data;
import sim.EnemyWave;
import sim.SelfWave;
import sim.Stat;
import sim.Wave;

public class WaveListener
implements INotifiable,
IDrawable {
    private Painter _painter;

    public WaveListener(Painter painter) {
        this._painter = painter;
    }

    @Override
    public void Initialize(MessageRouter router) {
        router.Subscribe(Message.Kind.PreUpdate, WaveListener$$Lambda$1.lambdaFactory$(this));
        router.Subscribe(Message.Kind.Update, WaveListener$$Lambda$2.lambdaFactory$(this));
        router.Subscribe(Message.Kind.PaintEnabled, WaveListener$$Lambda$3.lambdaFactory$(this));
        router.Subscribe(Message.Kind.PaintDisabled, WaveListener$$Lambda$4.lambdaFactory$(this));
        router.Subscribe(Message.Kind.SelfWaveNeutralized, WaveListener$$Lambda$5.lambdaFactory$(this));
        router.Subscribe(Message.Kind.EnemyWaveNeutralized, WaveListener$$Lambda$6.lambdaFactory$(this));
    }

    private final void Update(Message message) {
        for (Bot bot : Data.Robots.Enemies()) {
            if (!bot.Alive) continue;
            double gunHeat = Math.max(0.0, bot.Get(Stat.GUN_HEAT) - Data.Battle.GunCoolingRate);
            bot.Set(Stat.GUN_HEAT, gunHeat);
            if (gunHeat != 0.0) continue;
        }
    }

    private final void NeutralizeSelfWave(Message message) {
        ((SelfWave)Data.MyWaves.byIdentifier((String)message.subject)).status = Wave.WaveKind.Neutralized;
    }

    private final void NeutralizeEnemyWave(Message message) {
        ((EnemyWave)Data.EnemyWaves.byIdentifier((String)message.subject)).status = Wave.WaveKind.Neutralized;
    }

    private final void PreUpdate(Message message) {
        Bot self = Data.Robots.Self;
        ArrayList<Wave> myRemovable = new ArrayList<Wave>();
        for (Wave wave : Data.MyWaves) {
            wave.Update();
            for (Bot enemy : Data.Robots.Enemies()) {
                if (wave.intersects(enemy.HitBox)) {
                    message.respondWith(Message.Kind.SelfWaveIntersected).at(message.time).about(wave).send();
                    continue;
                }
                if (!wave.contains(enemy.HitBox)) continue;
                message.respondWith(Message.Kind.SelfWaveCompleted).at(message.time).about(wave).send();
                myRemovable.add(wave);
            }
        }
        Data.MyWaves.removeAll(myRemovable);
        Data.MyWaves.Update();
        ArrayList<Wave> enemyRemovable = new ArrayList<Wave>();
        for (Wave wave : Data.EnemyWaves) {
            wave.Update();
            if (wave.intersects(self.HitBox) || !wave.contains(self.HitBox)) continue;
            enemyRemovable.add(wave);
        }
        Data.EnemyWaves.removeAll(enemyRemovable);
    }

    private final void OnPaintEnabled(Message message) {
        this._painter.Register(this);
    }

    private final void OnPaintDisabled(Message message) {
        this._painter.UnRegister(this);
    }

    @Override
    public void Draw(Graphics2D e) {
        Color previous = e.getColor();
        e.setColor(Data.Robots.Self.color);
        for (Wave wave : Data.MyWaves) {
            wave.Draw(e);
        }
        for (Wave wave : Data.EnemyWaves) {
            e.setColor(((EnemyWave)wave).shooter.color);
            wave.Draw(e);
        }
        e.setColor(previous);
    }

    static /* synthetic */ void access$lambda$0(WaveListener waveListener, Message message) {
        waveListener.PreUpdate(message);
    }

    static /* synthetic */ void access$lambda$1(WaveListener waveListener, Message message) {
        waveListener.Update(message);
    }

    static /* synthetic */ void access$lambda$2(WaveListener waveListener, Message message) {
        waveListener.OnPaintEnabled(message);
    }

    static /* synthetic */ void access$lambda$3(WaveListener waveListener, Message message) {
        waveListener.OnPaintDisabled(message);
    }

    static /* synthetic */ void access$lambda$4(WaveListener waveListener, Message message) {
        waveListener.NeutralizeSelfWave(message);
    }

    static /* synthetic */ void access$lambda$5(WaveListener waveListener, Message message) {
        waveListener.NeutralizeEnemyWave(message);
    }
}

