/*
 * Decompiled with CFR 0.152.
 */
package ICS4U1;

import ICS4U1.EnemyRobot;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Vector;
import robocode.AdvancedRobot;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.StatusEvent;

public class Patrick_White_Schrodinger
extends AdvancedRobot {
    static Vector<EnemyRobot> enemies = new Vector();
    int scanDirection = 1;
    double sideInfluence = 1000000.0;
    Point2D.Double robotLocation = new Point2D.Double(0.0, 0.0);
    int spinTime = 0;
    Vector<Point2D.Double> gravityPoints;
    Point2D.Double moveTarget;
    boolean isFiring = false;
    EnemyRobot target;

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setBodyColor(new Color(0, 0, 0));
        this.setGunColor(new Color(127, 127, 127));
        this.setRadarColor(new Color(255, 255, 255));
        for (EnemyRobot enemy : enemies) {
            enemy.alive = true;
        }
        while (true) {
            this.gravityPoints = new Vector();
            if (this.getOthers() > 1) {
                this.gravityPoints.add(new Point2D.Double(this.getBattleFieldWidth() / 2.0, this.getBattleFieldHeight() / 2.0));
            }
            for (EnemyRobot enemy : enemies) {
                if (!enemy.alive) continue;
                this.gravityPoints.add(enemy.getLocation());
            }
            this.moveTarget = new Point2D.Double(this.robotLocation.x, this.robotLocation.y);
            for (Point2D.Double gravityPoint : this.gravityPoints) {
                this.moveTarget.setLocation(this.moveTarget.x + this.getForce((Point2D.Double)gravityPoint).x, this.moveTarget.y + this.getForce((Point2D.Double)gravityPoint).y);
            }
            this.moveTarget.setLocation(this.moveTarget.x + this.sideInfluence / Math.pow(this.robotLocation.x, 2.0), this.moveTarget.y);
            this.moveTarget.setLocation(this.moveTarget.x - this.sideInfluence / Math.pow(this.robotLocation.x - this.getBattleFieldWidth(), 2.0), this.moveTarget.y);
            this.moveTarget.setLocation(this.moveTarget.x, this.moveTarget.y + this.sideInfluence / Math.pow(this.robotLocation.y, 2.0));
            this.moveTarget.setLocation(this.moveTarget.x, this.moveTarget.y - this.sideInfluence / Math.pow(this.robotLocation.y - this.getBattleFieldHeight(), 2.0));
            double targetAngle = 57.29577951308232 * Math.atan2(this.moveTarget.x - this.robotLocation.x, this.moveTarget.y - this.robotLocation.y);
            switch ((int)((this.getHeading() - targetAngle) / 90.0)) {
                case 0: {
                    this.setAhead(Double.POSITIVE_INFINITY);
                    this.setTurnLeft(Double.NEGATIVE_INFINITY);
                    break;
                }
                case 1: {
                    this.setAhead(Double.NEGATIVE_INFINITY);
                    this.setTurnLeft(Double.NEGATIVE_INFINITY);
                    break;
                }
                case 2: {
                    this.setAhead(Double.NEGATIVE_INFINITY);
                    this.setTurnLeft(Double.POSITIVE_INFINITY);
                    break;
                }
                case 3: {
                    this.setAhead(Double.POSITIVE_INFINITY);
                    this.setTurnLeft(Double.POSITIVE_INFINITY);
                }
            }
            this.setTurnRadarLeft((double)this.scanDirection * Double.POSITIVE_INFINITY);
            if (!this.isFiring && enemies.size() >= this.getOthers()) {
                if (this.target == null) {
                    this.target = enemies.get(0);
                    for (EnemyRobot enemy : enemies) {
                        if (!(enemy.getDistance(this.robotLocation.x, this.robotLocation.y, this.getTime()) < this.target.getDistance(this.robotLocation.x, this.robotLocation.y, this.getTime())) || !enemy.alive) continue;
                        this.target = enemy;
                    }
                    System.out.println(this.target.name);
                }
                for (int i = 0; i < 300; ++i) {
                    double enemyX = this.target.getExpectedLocation((long)(this.getTime() + (long)i)).x;
                    double enemyY = this.target.getExpectedLocation((long)(this.getTime() + (long)i)).y;
                    double requiredGunAngle = 57.29577951308232 * Math.atan2(enemyX - this.robotLocation.x, enemyY - this.robotLocation.y);
                    if (requiredGunAngle < 0.0) {
                        requiredGunAngle += 360.0;
                    }
                    int timeToTurnGun = (int)Math.ceil(Math.abs((this.getGunHeading() - requiredGunAngle) / 25.0));
                    double bulletX = this.robotLocation.x + Math.sin(requiredGunAngle * Math.PI / 180.0) * 14.0 * (double)i;
                    double bulletY = this.robotLocation.y + Math.cos(requiredGunAngle * Math.PI / 180.0) * 14.0 * (double)i;
                    if (!(Math.abs(bulletX - enemyX) < 10.0) || !(Math.abs(bulletY - enemyY) < 10.0)) continue;
                    this.setTurnGunLeft(this.getGunHeading() - requiredGunAngle);
                    this.isFiring = true;
                    break;
                }
            }
            if (this.isFiring && this.getGunTurnRemaining() == 0.0) {
                this.fire(Math.min(2.0, this.getEnergy() - 0.1));
                this.isFiring = false;
            }
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        long timeTarget = Long.MAX_VALUE;
        if (enemies.size() >= this.getOthers()) {
            for (EnemyRobot enemy : enemies) {
                if (!enemy.alive) continue;
                timeTarget = Math.min(timeTarget, enemy.timeLastSeen);
            }
        }
        for (EnemyRobot enemy : enemies) {
            if (!enemy.alive || !enemy.getName().equals(e.getName())) continue;
            if (timeTarget == enemy.timeLastSeen && timeTarget > 0L) {
                this.scanDirection *= -1;
            }
            double x = this.robotLocation.x + Math.sin(Math.PI / 180 * (e.getBearing() + this.getHeading())) * e.getDistance();
            double y = this.robotLocation.y + Math.cos(Math.PI / 180 * (e.getBearing() + this.getHeading())) * e.getDistance();
            enemy.addLocation(x, y, e.getHeading(), this.getTime());
            return;
        }
        enemies.add(new EnemyRobot(e.getName(), this.getBattleFieldWidth(), this.getBattleFieldHeight()));
        double x = this.robotLocation.x + Math.sin(Math.PI / 180 * (e.getBearing() + this.getHeading())) * e.getDistance();
        double y = this.robotLocation.y + Math.cos(Math.PI / 180 * (e.getBearing() + this.getHeading())) * e.getDistance();
        enemies.get(enemies.size() - 1).addLocation(x, y, e.getHeading(), this.getTime());
    }

    public void onStatus(StatusEvent e) {
        this.robotLocation = new Point2D.Double(e.getStatus().getX(), e.getStatus().getY());
    }

    public void onRobotDeath(RobotDeathEvent e) {
        if (e.getName().equals(this.target.name)) {
            this.target = null;
        }
        for (EnemyRobot enemy : enemies) {
            if (!enemy.getName().equals(e.getName())) continue;
            enemy.alive = false;
            enemy.locations = new Vector();
            return;
        }
    }

    public void onHitWall(HitWallEvent e) {
    }

    public void onPaint(Graphics2D g) {
        this.setColors(new Color((float)Math.random(), (float)Math.random(), (float)Math.random()), new Color((float)Math.random(), (float)Math.random(), (float)Math.random()), new Color((float)Math.random(), (float)Math.random(), (float)Math.random()));
        g.setColor(Color.red);
        for (EnemyRobot enemy : enemies) {
            if (!enemy.alive) continue;
            g.drawOval((int)enemy.getExpectedLocation((long)this.getTime()).x - 10, (int)enemy.getExpectedLocation((long)this.getTime()).y - 10, 20, 20);
        }
        g.setColor(Color.green);
        g.drawOval((int)this.moveTarget.x - 10, (int)this.moveTarget.y - 10, 20, 20);
        for (Point2D.Double gravityPoint : this.gravityPoints) {
            g.drawOval((int)gravityPoint.x - 2, (int)gravityPoint.y - 2, 4, 4);
            g.drawLine((int)gravityPoint.x, (int)gravityPoint.y, (int)(gravityPoint.x + this.getForce((Point2D.Double)gravityPoint).x), (int)(gravityPoint.y + this.getForce((Point2D.Double)gravityPoint).y));
        }
        g.drawLine(0, (int)(this.getBattleFieldHeight() / 2.0), (int)(this.sideInfluence / Math.pow(this.robotLocation.x, 2.0)), (int)(this.getBattleFieldHeight() / 2.0));
        g.drawLine((int)this.getBattleFieldWidth(), (int)(this.getBattleFieldHeight() / 2.0), (int)(this.getBattleFieldWidth() - this.sideInfluence / Math.pow(this.robotLocation.x - this.getBattleFieldWidth(), 2.0)), (int)(this.getBattleFieldHeight() / 2.0));
        g.drawLine((int)(this.getBattleFieldWidth() / 2.0), 0, (int)(this.getBattleFieldWidth() / 2.0), (int)(this.sideInfluence / Math.pow(this.robotLocation.y, 2.0)));
        g.drawLine((int)(this.getBattleFieldWidth() / 2.0), (int)this.getBattleFieldHeight(), (int)(this.getBattleFieldWidth() / 2.0), (int)(this.getBattleFieldHeight() - this.sideInfluence / Math.pow(this.robotLocation.y - this.getBattleFieldHeight(), 2.0)));
    }

    public Point2D.Double getForce(Point2D.Double gravityPoint) {
        double repelFactor = 1000000.0 / (Math.pow(this.robotLocation.x - gravityPoint.x, 2.0) + Math.pow(this.robotLocation.y - gravityPoint.y, 2.0));
        double angle = Math.atan2(this.robotLocation.x - gravityPoint.x, this.robotLocation.y - gravityPoint.y);
        return new Point2D.Double(Math.sin(angle) * repelFactor, Math.cos(angle) * repelFactor);
    }
}

