/*
 * Decompiled with CFR 0.152.
 */
package MGAM;

import MGAM.BotMaster;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Enemy {
    public String szName;
    public double dX;
    public double dY;
    public double dDistance;
    public double dBearing;
    public double dBearingRad;
    public double dHeading;
    public double dHeadingRad;
    public double dEnergy;
    public double dPrevEnergy;
    public double dVelocity;
    public double dScannedTime;
    public double dAbsoluteBearingRadians;
    public boolean bDead;

    Enemy() {
        this.Reset();
    }

    public Enemy(Enemy other) {
        this.Reset();
        this.szName = other.szName;
        this.dX = other.dX;
        this.dY = other.dY;
        this.dDistance = other.dDistance;
        this.dBearing = other.dBearing;
        this.dBearingRad = other.dBearingRad;
        this.dHeading = other.dHeading;
        this.dHeadingRad = other.dHeadingRad;
        this.dEnergy = other.dEnergy;
        this.dPrevEnergy = other.dPrevEnergy;
        this.dVelocity = other.dVelocity;
        this.dScannedTime = other.dScannedTime;
        this.dAbsoluteBearingRadians = other.dAbsoluteBearingRadians;
        this.bDead = other.bDead;
    }

    public Enemy update(ScannedRobotEvent e, BotMaster bot) {
        this.szName = e.getName();
        this.dDistance = e.getDistance();
        this.dBearingRad = e.getBearingRadians();
        this.dHeadingRad = Utils.normalAbsoluteAngle((double)e.getHeadingRadians());
        this.dVelocity = e.getVelocity();
        this.dPrevEnergy = this.dEnergy;
        this.dEnergy = e.getEnergy();
        this.dAbsoluteBearingRadians = Utils.normalAbsoluteAngle((double)(bot.getHeadingRadians() + this.dBearingRad));
        this.dX = bot.getX() + Math.sin(this.dAbsoluteBearingRadians) * this.dDistance;
        this.dY = bot.getY() + Math.cos(this.dAbsoluteBearingRadians) * this.dDistance;
        return this;
    }

    public double getDistance(BotMaster bot) {
        double deltaX = bot.getX() - this.dX;
        double deltaY = bot.getY() - this.dY;
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY);
    }

    public void Reset() {
        this.dEnergy = 0.0;
        this.dBearing = 0.0;
        this.dBearingRad = 0.0;
        this.dHeading = 0.0;
        this.dHeadingRad = 0.0;
        this.dVelocity = 0.0;
        this.bDead = false;
    }
}

