/*
 * Decompiled with CFR 0.152.
 */
package br2;

import MGAM.BotMaster;
import MGAM.Enemy;
import MGAM.Gun;
import br2.MD_Bullet;
import br2.MD_GFDirect;
import br2.MD_GunFunction;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Hashtable;
import java.util.Vector;
import robocode.util.Utils;

public class MD_ShootSmart
extends Gun {
    double mGunStrength;
    public Vector<MD_Bullet> mBullets = new Vector();
    public Hashtable<String, MD_GunFunction> mGunFunctions = new Hashtable();
    Enemy mCurrentEnemy;

    public MD_ShootSmart(BotMaster bot) {
        super(bot);
        this.mGunFunctions.put("DirectFire", new MD_GFDirect("DirectFire"));
        this.mGunStrength = 0.1;
    }

    @Override
    public void shoot() {
        int i;
        MD_Bullet newBullet;
        for (Enemy currEnemy : BotMaster.enemies.values()) {
            if (currEnemy.bDead) continue;
            double delta = currEnemy.dPrevEnergy - currEnemy.dEnergy;
            if (delta > 0.0 && delta <= 3.0) {
                double atMeDelta = delta;
                if (this.bot.getOthers() > 3) {
                    double percent = 0.5 + (double)(13 - this.bot.getOthers()) * 0.05;
                }
                Point2D.Double currEnemyPos = new Point2D.Double(currEnemy.dX, currEnemy.dY);
                double angle = MD_Bullet.findAngle(new Point2D.Double(this.bot.getX(), this.bot.getY()), currEnemyPos);
                MD_Bullet newBullet2 = new MD_Bullet(atMeDelta, currEnemy.dX, currEnemy.dY, this, angle, true, true);
                Enemy secondaryTarget = this.bot.self;
                double secondaryDistance = currEnemyPos.distance(this.bot.getX(), this.bot.getY());
                for (Enemy closerEnemy : BotMaster.enemies.values()) {
                    if (closerEnemy.bDead || closerEnemy.szName == currEnemy.szName) continue;
                    Point2D.Double closePos = new Point2D.Double(closerEnemy.dX, closerEnemy.dY);
                    double checkDist = currEnemyPos.distance(closerEnemy.dX, closerEnemy.dY);
                    if (!(checkDist < secondaryDistance)) continue;
                    secondaryDistance = checkDist;
                    secondaryTarget = closerEnemy;
                }
                double secondaryAngle = MD_Bullet.findAngle(new Point2D.Double(secondaryTarget.dX, secondaryTarget.dY), currEnemyPos);
                MD_Bullet secondaryBullet = new MD_Bullet(delta, currEnemy.dX, currEnemy.dY, this, secondaryAngle, true, true);
                for (Enemy target : BotMaster.enemies.values()) {
                    if (target.bDead || target.szName == currEnemy.szName) continue;
                    newBullet2.addEnemy(target);
                    secondaryBullet.addEnemy(target);
                }
                newBullet2.addEnemy(this.bot.self);
                secondaryBullet.addEnemy(this.bot.self);
                this.mBullets.add(newBullet2);
                this.mBullets.add(secondaryBullet);
            }
            currEnemy.dPrevEnergy = currEnemy.dEnergy;
        }
        if (this.bot.getEnergy() <= 0.1) {
            return;
        }
        boolean addedBullet = false;
        if (this.bot.getGunHeat() == 0.0 && this.bot.getGunTurnRemaining() == 0.0 && this.mGunStrength >= 0.1) {
            if (this.mGunStrength > 3.0) {
                this.mGunStrength = 3.0;
            }
            if (this.mGunStrength > this.bot.getEnergy() - 0.1) {
                this.mGunStrength = this.bot.getEnergy() - 0.1;
            }
            this.bot.setFireBullet(this.mGunStrength);
            newBullet = new MD_Bullet(this.mGunStrength, this.bot.getX(), this.bot.getY(), this, 0.0, true, false);
            for (Enemy target : BotMaster.enemies.values()) {
                if (target.bDead) continue;
                newBullet.addEnemy(target);
            }
            this.mBullets.add(newBullet);
            addedBullet = true;
        }
        if (!addedBullet) {
            newBullet = new MD_Bullet(this.mGunStrength, this.bot.getX(), this.bot.getY(), this, 0.0, false, false);
            for (Enemy target : BotMaster.enemies.values()) {
                if (target.bDead) continue;
                newBullet.addEnemy(target);
            }
            this.mBullets.add(newBullet);
        }
        Vector<MD_Bullet> toRemove = new Vector<MD_Bullet>();
        for (i = 0; i < this.mBullets.size(); ++i) {
            boolean bTargetsLeft = this.mBullets.get(i).update();
            if (bTargetsLeft) continue;
            toRemove.add(this.mBullets.get(i));
        }
        for (i = 0; i < toRemove.size(); ++i) {
            this.mBullets.remove(toRemove.get(i));
        }
        MD_GunFunction bestGun = null;
        double bestStrength = 0.0;
        for (MD_GunFunction currentGun : this.mGunFunctions.values()) {
            double newStrength = currentGun.aimGun(this.bot);
            if (!(newStrength > bestStrength)) continue;
            bestStrength = newStrength;
            bestGun = currentGun;
        }
        if (bestStrength > 0.0 && bestGun != null) {
            this.mGunStrength = bestStrength;
            double angle = bestGun.getAngle();
            this.bot.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(angle -= this.bot.getGunHeadingRadians())));
        }
        if (!(this.bot.getEnergy() > 20.0)) {
            double mult = this.bot.getEnergy() / 20.0;
            this.mGunStrength *= mult;
            if (this.mGunStrength < 0.1) {
                this.mGunStrength = 0.0;
            }
        }
    }

    @Override
    public void onPaint(Graphics2D g) {
        for (MD_Bullet bullet : this.mBullets) {
            bullet.onPaint(g);
        }
    }
}

