/*
 * Decompiled with CFR 0.152.
 */
package romz.robot.circular;

import java.awt.Color;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;
import romz.model.Enemy;
import romz.util.UtilRobot;

public class WildRabbit
extends UtilRobot {
    private static final double HALF_ROBOT_SIZE = 18.0;
    private static final double RADAR_SECURITY_DISTANCE = 26.0;
    private static final int RESCAN_DELAY = 3;
    private static final int FULL_TURN = 360;
    private static final double OSCILLATION_DISTANCE = 250.0;
    private static final double MIN_WALL_DISTANCE = 100.0;
    private static final double DESIRED_ENEMY_DISTANCE = 200.0;
    private static final double MIN_DISTANCE_ADJUSTMENT_FACTOR = 0.25;
    private static final double MAX_DISTANCE_ADJUSTMENT_FACTOR = 1.75;
    private static final int DISTANCE_SENSITIVITY = 20;
    private static final double MAX_POWER_DISTANCE = 300.0;
    private double fieldHeight;
    private double fieldWidth;
    private long time;
    private double energy;
    private double x;
    private double y;
    private double heading;
    private double radarHeading;
    private double radarTurnRemaining;
    private double gunHeading;
    private double gunHeat;
    private double distanceRemaining;
    private int gear = 1;
    private Enemy enemy;
    private Enemy lastEnemy;

    private void init() {
        this.setColors(Color.CYAN, Color.DARK_GRAY, Color.BLACK);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.fieldHeight = this.getBattleFieldHeight();
        this.fieldWidth = this.getBattleFieldWidth();
    }

    public void run() {
        this.init();
        while (true) {
            this.updateVariables();
            this.radar();
            this.move();
            this.aim();
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.lastEnemy = this.enemy;
        this.enemy = new Enemy();
        this.enemy.timeScanned = this.getTime();
        this.enemy.energy = e.getEnergy();
        this.enemy.relativeBearing = e.getBearing();
        this.enemy.absoluteBearing = Utils.normalAbsoluteAngleDegrees((double)(this.heading + this.enemy.relativeBearing));
        this.enemy.distance = e.getDistance();
        this.enemy.x = this.x + this.enemy.distance * this.sin(this.enemy.absoluteBearing);
        this.enemy.y = this.y + this.enemy.distance * this.cos(this.enemy.absoluteBearing);
        this.enemy.heading = e.getHeading();
        this.enemy.velocity = e.getVelocity();
        if (this.lastEnemy != null) {
            this.enemy.acceleration = (this.enemy.velocity - this.lastEnemy.velocity) / (double)(this.enemy.timeScanned - this.lastEnemy.timeScanned);
            this.enemy.turnRate = Utils.normalRelativeAngleDegrees((double)(this.enemy.heading - this.lastEnemy.heading)) / (double)(this.enemy.timeScanned - this.lastEnemy.timeScanned);
        }
    }

    private void updateVariables() {
        this.time = this.getTime();
        this.energy = this.getEnergy();
        this.x = this.getX();
        this.y = this.getY();
        this.heading = this.getHeading();
        this.radarHeading = this.getRadarHeading();
        this.radarTurnRemaining = this.getRadarTurnRemaining();
        this.gunHeading = this.getGunHeading();
        this.gunHeat = this.getGunHeat();
        this.distanceRemaining = this.getDistanceRemaining();
        if (this.enemy != null) {
            this.enemy.absoluteBearing = this.heading + this.enemy.relativeBearing;
        }
    }

    private void radar() {
        if (this.fullScanNeeded()) {
            this.fullScan();
        } else {
            this.lockRadar();
        }
    }

    private boolean fullScanNeeded() {
        if (this.enemy == null) {
            return true;
        }
        return this.time - this.enemy.timeScanned > 3L;
    }

    private void fullScan() {
        if (this.abs(this.radarTurnRemaining) < 45.0) {
            double angleToCenter = this.heading(this.x, this.y, this.fieldWidth / 2.0, this.fieldHeight / 2.0);
            double orientation = this.signum(Utils.normalRelativeAngleDegrees((double)(angleToCenter - this.gunHeading)));
            double fullTurn = orientation * 360.0;
            this.setTurnRight(fullTurn);
            this.setTurnGunRight(fullTurn);
            this.setTurnRadarRight(fullTurn);
        }
    }

    private void lockRadar() {
        double radarOffset = Utils.normalRelativeAngleDegrees((double)(this.enemy.absoluteBearing - this.radarHeading));
        double additionalTurn = this.signum(radarOffset) * this.min(this.atan(26.0 / this.enemy.distance), 45.0);
        double radarTurn = radarOffset + additionalTurn;
        this.setTurnRadarRight(radarTurn);
    }

    private void move() {
        if (this.enemy != null) {
            this.adjustedPerpendicularHeading();
        }
        this.gear();
    }

    private void adjustedPerpendicularHeading() {
        int side = this.enemy.relativeBearing > 0.0 ? 1 : -1;
        double distanceAdjustmentFactor = this.getDistanceAdjustmentFactor();
        double adjustedPerpendicularAngle = distanceAdjustmentFactor * 90.0;
        double adjustedPerpendicularHeading = Utils.normalAbsoluteAngleDegrees((double)(this.enemy.absoluteBearing - (double)side * adjustedPerpendicularAngle));
        double headingOffset = Utils.normalRelativeAngleDegrees((double)(adjustedPerpendicularHeading - this.heading));
        this.setTurnRight(headingOffset);
    }

    private double getDistanceAdjustmentFactor() {
        double rawDistanceAdjustmentFactor = 1.0 + 20.0 * ((double)this.gear * (200.0 - this.enemy.distance)) / 200.0;
        return this.limit(0.25, rawDistanceAdjustmentFactor, 1.75);
    }

    private void gear() {
        if (this.reverseNeeded()) {
            this.gear = -this.gear;
            double distance = (0.5 + this.random()) * 250.0;
            if (this.gear > 0) {
                this.setAhead(distance);
            } else {
                this.setBack(distance);
            }
        }
    }

    private boolean reverseNeeded() {
        return this.distanceRemaining == 0.0 || this.tooCloseFromWall();
    }

    private boolean tooCloseFromWall() {
        double trueHeading = this.gear > 0 ? this.heading : this.heading + 180.0;
        double projectedX = this.x + 100.0 * this.sin(trueHeading);
        double projectedY = this.y + 100.0 * this.cos(trueHeading);
        return projectedX < 18.0 || projectedX > this.fieldWidth - 18.0 || projectedY < 18.0 || projectedY > this.fieldHeight - 18.0;
    }

    private void aim() {
        if (this.enemy != null && this.lastEnemy != null && this.enemy.timeScanned > this.time - 3L) {
            double firePower = this.selectFirePower();
            double fireAngle = this.selectFireAngle(firePower);
            double gunTurn = Utils.normalRelativeAngleDegrees((double)(fireAngle - this.gunHeading));
            this.setTurnGunRight(gunTurn);
            if (this.gunIsAdjusted(gunTurn) && this.gunHeat == 0.0 && this.energy > 0.1) {
                this.setFire(firePower);
            }
        }
    }

    private boolean gunIsAdjusted(double gunTurn) {
        return gunTurn < this.atan(18.0 / this.enemy.distance);
    }

    private double selectFirePower() {
        double firePower = 0.0;
        if (this.energy > 0.1) {
            firePower = this.enemy.energy <= 4.0 ? this.enemy.energy / 4.0 : (this.enemy.energy <= 16.0 ? (this.enemy.energy + 2.0) / 6.0 : 3.0 * (300.0 / this.enemy.distance));
            firePower = this.min(firePower, (this.energy - 0.1) / 8.0);
            firePower = this.limit(0.1, firePower, 3.0);
        }
        return firePower;
    }

    private double selectFireAngle(double firePower) {
        double bulletVelocity = Rules.getBulletSpeed((double)firePower);
        double enemyX = this.enemy.x;
        double enemyY = this.enemy.y;
        double enemyHeading = this.enemy.heading;
        double enemyTurnRate = this.enemy.turnRate;
        double enemyVelocity = this.enemy.velocity;
        double enemyAcceleration = this.enemy.acceleration;
        int t = 0;
        do {
            enemyHeading = Utils.normalRelativeAngleDegrees((double)(enemyHeading + enemyTurnRate));
        } while ((double)(++t) * bulletVelocity < this.distance(this.x, this.y, enemyX = this.limit(18.0, enemyX + (enemyVelocity = this.min(8.0, enemyVelocity + enemyAcceleration)) * this.sin(enemyHeading), this.fieldWidth - 18.0), enemyY = this.limit(18.0, enemyY + enemyVelocity * this.cos(enemyHeading), this.fieldHeight - 18.0)));
        double fireAngle = this.heading(this.x, this.y, enemyX, enemyY);
        return Utils.normalAbsoluteAngleDegrees((double)fireAngle);
    }
}

