/*
 * Decompiled with CFR 0.152.
 */
package gre.svman4.morfeas;

import gre.svman4.WaveBullet;
import gre.svman4.useful.FieldPoint;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import robocode.util.Utils;

public class MineWaveBullet
extends WaveBullet {
    public double enemyVelocity;
    public double lastEnemyVelocity;
    public int moveTime;
    public boolean paint = false;

    private Color getColor(double lower, double val, double higher) {
        double range = higher - lower;
        double value = Math.min(range, Math.max(val - lower, 0.0));
        double H = value / range * 0.4;
        double S = 0.9;
        double B = 0.9;
        return Color.getHSBColor((float)H, (float)S, (float)B);
    }

    private float[] getCurrentStatus() {
        return this.enemy.getGunCurrentStatus(this.distanceToEnemyPosition, this.enemyVelocity, this.relativePosition, this.moveTime);
    }

    @Override
    public int getFactorIndex(FieldPoint targetLocation) {
        double offsetAngle = this.fireLocation.getAngleTo(targetLocation) - this.directAngle;
        double factor = Utils.normalRelativeAngle((double)offsetAngle) / this.enemy.getMaxEscapeAngle(this.bulletVelocity) * (double)this.lateralDirection;
        return (int)MineWaveBullet.limit(0.0, factor * 30.0 + 30.0, 60.0);
    }

    double getShootingAngle(int OffsetBin) {
        double factor = (2.0 * (double)OffsetBin - 61.0 - 1.0) / 60.0;
        double offsetAngle = factor * this.enemy.getMaxEscapeAngle(this.bulletVelocity * (double)this.lateralDirection);
        double shootingAngle = offsetAngle + this.directAngle;
        return shootingAngle;
    }

    private Stroke getStroke(double min, double d, double max) {
        double range = max - min;
        double val = d - min;
        return new BasicStroke((float)(val / range) * 5.0f);
    }

    public void logGunHit() {
        this.enemy.logGunHit(this, this.getOffsetAngle(this.enemy));
    }

    public void logGunHit(FieldPoint hitPoint) {
        this.enemy.logGunHit(this, this.getOffsetAngle(hitPoint));
    }

    public double getOffsetAngle(FieldPoint targetLocation) {
        double offsetAngle = this.fireLocation.getAngleTo(targetLocation) - this.directAngle;
        return Utils.normalRelativeAngle((double)offsetAngle);
    }

    public void onPaint(Graphics2D g) {
        if (!this.paint) {
            return;
        }
        float[] curStats = this.getCurrentStatus();
        double max = curStats[0];
        double min = curStats[0];
        for (int j = 1; j < 61; ++j) {
            if ((double)curStats[j] < min) {
                min = curStats[j];
                continue;
            }
            if (!((double)curStats[j] > max)) continue;
            max = curStats[j];
        }
        g.setStroke(new BasicStroke());
        g.setColor(Color.BLACK);
        FieldPoint temp1 = this.fireLocation.project(this.distanceTraveled - this.bulletVelocity, this.getShootingAngle(0));
        FieldPoint temp0 = this.fireLocation.project(this.distanceTraveled, this.directAngle);
        g.drawLine((int)this.fireLocation.x, (int)this.fireLocation.y, (int)temp0.x, (int)temp0.y);
        for (int j = 1; j < 61; ++j) {
            temp0.setLocation(temp1);
            temp1.setLocation(this.fireLocation.project(this.distanceTraveled - this.bulletVelocity, this.getShootingAngle(j)));
            g.setStroke(this.getStroke(min, curStats[j], max));
            g.setColor(this.getColor(min, curStats[j], max));
            g.drawLine((int)temp0.x, (int)temp0.y, (int)temp1.x, (int)temp1.y);
            g.fillOval((int)temp1.x - 1, (int)temp1.y - 1, 2, 2);
        }
    }
}

