/*
 * Decompiled with CFR 0.152.
 */
package metal.shared;

import java.util.Random;
import java.util.TreeMap;
import metal.shared.MAngle;
import metal.shared.MBotData;
import metal.shared.MBullet;
import metal.shared.MBulletEnemy;
import metal.shared.MChromosoom;
import metal.shared.MDna;
import metal.shared.MMath;
import metal.shared.MPoint;
import robocode.HitByBulletEvent;

public class MChassisDna5 {
    private static Random rand = new Random();
    private static MPoint centre = null;
    private static MPoint nextPoint = null;
    private static MPoint enemyPoint = null;
    private static double firePower = 0.0;
    private static double fireTime = 0.0;
    static MDna[][] dnas = new MDna[4][50];
    static int i = 0;
    static boolean first = true;
    static int c = 0;
    static int speedCounter = 0;
    static double MIN_DIST = 60.0;
    static double MAX_DIST;
    static double dir;
    static double coolTime;
    static double speed;
    public TreeMap bullets = new TreeMap();
    static int index;
    static int indexS;

    public MChassisDna5() {
        MBotData.print("SYSTEM:  Chassis    ... OK");
        centre = new MPoint(MBotData.self.getBattleFieldWidth() / 2.0, MBotData.self.getBattleFieldHeight() / 2.0);
        if (first) {
            MChassisDna5.init();
            MChassisDna5.initDNA();
            first = false;
        }
    }

    private static void init() {
        for (int j = 0; j < 4; ++j) {
            for (int i = 0; i < dnas[j].length; ++i) {
                MChassisDna5.dnas[j][i] = new MDna();
            }
        }
    }

    private static void initDNA() {
        for (int j = 0; j < 4; ++j) {
            for (int i = 0; i < dnas[j].length; ++i) {
                dnas[j][i].mergeDna(dnas[j][i].furtilize());
            }
        }
    }

    public static void move() {
        try {
            MChassisDna5.movement();
        }
        catch (Exception e) {
            MBotData.err("SYSTEM:  Chassis    ... FAILED");
            e.printStackTrace();
        }
    }

    private static void movement() {
        double L = 0.0;
        double angle = 0.0;
        double distAngle = 0.0;
        double moveAngle = 0.0;
        double distance = MBotData.enemy.last.distance;
        boolean isCentered = false;
        boolean isVerticle = false;
        index = (int)MMath.clamp(30.0, 0.0, MBotData.enemy.last.distance / MBullet.getSpeed(MBotData.enemy.energyDiff));
        indexS = (int)(MMath.abs(MBotData.self.getVelocity()) / 3.0);
        if (MBotData.enemy.isFired && coolTime < (double)MBotData.self.getTime()) {
            MBotData.enemy.isFired = false;
            ++c;
            firePower = MBotData.enemy.energyDiff;
            fireTime = MBotData.enemy.time;
            coolTime = MBotData.self.getTime() - 1L + (long)((1.0 + firePower / 5.0) / MBotData.self.getGunCoolingRate());
            speed = MMath.sign(Math.random() < 0.8 ? -1 : 1);
            if (MMath.abs(MBotData.self.getVelocity()) > 1.0) {
                speed = -1.0;
            }
            if (MMath.abs(MBotData.enemy.energyDiff) > 2.0) {
                speed = 1.0;
            }
        }
        if (MMath.abs(MBotData.self.getDistanceRemaining()) <= MIN_DIST || MMath.abs(MBotData.self.getDistanceRemaining()) > 170.0) {
            if (MMath.abs(MBotData.enemy.energyDiff - 1.55) < 1.76 || MBotData.enemy.distance < 600.0 || (double)(MBotData.self.getTime() + 3L) >= coolTime) {
                MBotData.self.setMaxVelocity(8.0);
                MIN_DIST = 20.0;
                angle = MMath.abs((MBotData.enemy.bearing + 360.0) % 90.0);
                isCentered = MBotData.getLocation().distance(centre) < centre.distance(0.0, 0.0) / 2.0;
                isVerticle = angle < 22.5 || angle > 157.5 || isCentered;
                distAngle = 2.0 * Math.toDegrees(Math.asin(5.0 / MBullet.getSpeed(MBotData.enemy.energyDiff)));
                if (isVerticle) {
                    distAngle = Math.toDegrees(Math.asin(10.0 / MBullet.getSpeed(MBotData.enemy.energyDiff)));
                }
                double val = Double.MAX_VALUE;
                double tmp = 0.0;
                int in = 0;
                MChromosoom crom = null;
                for (int j = 0; j < 3; ++j) {
                    for (int i = 0; i < dnas.length; ++i) {
                        if (i == index) {
                            tmp += (double)(MChassisDna5.dnas[MChassisDna5.indexS][i].getChromosoom((int)j).fitness * MChassisDna5.dnas[MChassisDna5.indexS][i].getChromosoom((int)j).fitness) * 1.4;
                            continue;
                        }
                        if (i < index) {
                            tmp += (double)MChassisDna5.dnas[MChassisDna5.indexS][i].getChromosoom((int)j).fitness * 0.72;
                            continue;
                        }
                        tmp += (double)MChassisDna5.dnas[MChassisDna5.indexS][i].getChromosoom((int)j).fitness * 0.43;
                    }
                    if (tmp < val) {
                        val = tmp;
                        in = j;
                    }
                    tmp = 0.0;
                }
                crom = dnas[indexS][index].getChromosoom(in);
                MIN_DIST = 50.0;
                distAngle = MMath.atan(MMath.tan(distAngle) + (MIN_DIST / 2.0 - 4.0) / distance);
                if (distance < 200.0) {
                    distance += 30.0;
                }
                moveAngle = 4.0 * MMath.sign(MMath.random(-1.0, 1.0));
                do {
                    moveAngle += distAngle * (crom.value * 6.0) * dir;
                    L = distance;
                    if (isVerticle) {
                        L /= MMath.cos(moveAngle);
                    }
                    distance -= 10.0;
                } while (MPoint.getWallDistance(nextPoint = MPoint.getPoint(MBotData.enemy, MBotData.enemy.bearing + moveAngle, -L)) < 30.0);
                double d = MAX_DIST = MBotData.enemy.distance > 400.0 ? MBotData.enemy.distance / 2.2 : MBotData.enemy.distance / 1.8;
                if (++i == 0) {
                    MChassisDna5.dnas[MChassisDna5.indexS][MChassisDna5.index].getChromosoom((String)new StringBuffer().append((int)MChassisDna5.i).append((String)"").toString()).fitness = (int)((double)MChassisDna5.dnas[MChassisDna5.indexS][MChassisDna5.index].getChromosoom((String)new StringBuffer().append((int)MChassisDna5.i).append((String)"").toString()).fitness - ((double)MChassisDna5.dnas[MChassisDna5.indexS][MChassisDna5.index > 0 ? MChassisDna5.index - 1 : MChassisDna5.index].getChromosoom((String)new StringBuffer().append((int)MChassisDna5.i).append((String)"").toString()).fitness * (MBotData.enemy.distance / MBullet.getSpeed(MBotData.enemy.energyDiff)) - (double)MChassisDna5.dnas[MChassisDna5.indexS][MChassisDna5.index + 1].getChromosoom((String)new StringBuffer().append((int)MChassisDna5.i).append((String)"").toString()).fitness * 1.83 * (Math.abs(MBotData.self.getVelocity() / 3.0) + 1.0) * (MBotData.enemy.distance / MBullet.getSpeed(MBotData.enemy.energyDiff))));
                    dnas[indexS][index].mutate(i + "");
                } else if (i == -1) {
                    MChassisDna5.dnas[MChassisDna5.indexS][MChassisDna5.index].getChromosoom((String)new StringBuffer().append((int)MChassisDna5.i).append((String)"").toString()).fitness = (int)((double)MChassisDna5.dnas[MChassisDna5.indexS][MChassisDna5.index].getChromosoom((String)new StringBuffer().append((int)MChassisDna5.i).append((String)"").toString()).fitness - ((double)MChassisDna5.dnas[MChassisDna5.indexS][MChassisDna5.index > 0 ? MChassisDna5.index - 1 : MChassisDna5.index].getChromosoom((String)new StringBuffer().append((int)MChassisDna5.i).append((String)"").toString()).fitness * (MBotData.enemy.distance / MBullet.getSpeed(MBotData.enemy.energyDiff)) - (double)MChassisDna5.dnas[MChassisDna5.indexS][MChassisDna5.index + 1].getChromosoom((String)new StringBuffer().append((int)MChassisDna5.i).append((String)"").toString()).fitness * 1.5 * (MBotData.enemy.distance / MBullet.getSpeed(MBotData.enemy.energyDiff))));
                    dnas[indexS][index].mutate(i + "");
                } else if (i == 1) {
                    MChassisDna5.dnas[MChassisDna5.indexS][MChassisDna5.index].getChromosoom((String)new StringBuffer().append((int)MChassisDna5.i).append((String)"").toString()).fitness = (int)((double)MChassisDna5.dnas[MChassisDna5.indexS][MChassisDna5.index].getChromosoom((String)new StringBuffer().append((int)MChassisDna5.i).append((String)"").toString()).fitness - ((double)MChassisDna5.dnas[MChassisDna5.indexS][MChassisDna5.index > 0 ? MChassisDna5.index - 1 : MChassisDna5.index].getChromosoom((String)new StringBuffer().append((int)MChassisDna5.i).append((String)"").toString()).fitness * (MBotData.enemy.distance / MBullet.getSpeed(MBotData.enemy.energyDiff)) - (double)MChassisDna5.dnas[MChassisDna5.indexS][MChassisDna5.index + 1].getChromosoom((String)new StringBuffer().append((int)MChassisDna5.i).append((String)"").toString()).fitness * 1.55 * (Math.abs(MBotData.self.getVelocity() / 3.0) + 1.0) * (MBotData.enemy.distance / MBullet.getSpeed(MBotData.enemy.energyDiff))));
                    dnas[indexS][index].mutate(i + "");
                } else if (i == -2) {
                    MChassisDna5.dnas[MChassisDna5.indexS][MChassisDna5.index].getChromosoom((String)new StringBuffer().append((int)MChassisDna5.i).append((String)"").toString()).fitness = (int)((double)MChassisDna5.dnas[MChassisDna5.indexS][MChassisDna5.index].getChromosoom((String)new StringBuffer().append((int)MChassisDna5.i).append((String)"").toString()).fitness - ((Math.abs(MBotData.self.getVelocity() / 3.0) + 1.0) * (MBotData.enemy.distance / MBullet.getSpeed(MBotData.enemy.energyDiff)) - (double)MChassisDna5.dnas[MChassisDna5.indexS][MChassisDna5.index > 0 ? MChassisDna5.index - 1 : MChassisDna5.index].getChromosoom((String)new StringBuffer().append((int)MChassisDna5.i).append((String)"").toString()).fitness * (MBotData.enemy.distance / MBullet.getSpeed(MBotData.enemy.energyDiff)) - (double)MChassisDna5.dnas[MChassisDna5.indexS][MChassisDna5.index + 1].getChromosoom((String)new StringBuffer().append((int)MChassisDna5.i).append((String)"").toString()).fitness * (Math.abs(MBotData.self.getVelocity() / 3.0) + 1.0) * (MBotData.enemy.distance / MBullet.getSpeed(MBotData.enemy.energyDiff))));
                    dnas[indexS][index].mutate(i + "");
                } else if (i == 2) {
                    MChassisDna5.dnas[MChassisDna5.indexS][MChassisDna5.index].getChromosoom((String)new StringBuffer().append((int)MChassisDna5.i).append((String)"").toString()).fitness = (int)((double)MChassisDna5.dnas[MChassisDna5.indexS][MChassisDna5.index].getChromosoom((String)new StringBuffer().append((int)MChassisDna5.i).append((String)"").toString()).fitness - ((Math.abs(MBotData.self.getVelocity() / 3.0) + 1.0) * (MBotData.enemy.distance / MBullet.getSpeed(MBotData.enemy.energyDiff)) * (double)MBotData.enemy.isAccelarating() - (double)MChassisDna5.dnas[MChassisDna5.indexS][MChassisDna5.index > 0 ? MChassisDna5.index - 1 : MChassisDna5.index].getChromosoom((String)new StringBuffer().append((int)MChassisDna5.i).append((String)"").toString()).fitness * (MBotData.enemy.distance / MBullet.getSpeed(MBotData.enemy.energyDiff)) - (double)MChassisDna5.dnas[MChassisDna5.indexS][MChassisDna5.index + 1].getChromosoom((String)new StringBuffer().append((int)MChassisDna5.i).append((String)"").toString()).fitness * 8.52 * (Math.abs(MBotData.self.getVelocity() / 3.0) + 1.0) * (MBotData.enemy.distance / MBullet.getSpeed(MBotData.enemy.energyDiff)) * (double)MBotData.enemy.isAccelarating()));
                    dnas[indexS][index].mutate(i + "");
                } else if (i == -3 || i == 3) {
                    // empty if block
                }
                dir = MMath.sign(crom.max);
                try {
                    dnas[indexS][index].mutate("" + in);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                MBotData.self.setMaxVelocity(MMath.abs(MBotData.self.getTurnRemaining()) > 45.0 ? 0.0 : 3.0);
            } else if (MBotData.self.getDistanceRemaining() <= 10.0) {
                nextPoint = MPoint.getPoint(MBotData.enemy, MBotData.enemy.bearing + Math.toDegrees(Math.random() * 0.04 - 0.02), -MBotData.enemy.distance);
                ++i;
            }
            if (nextPoint != null) {
                MChassisDna5.go(nextPoint);
            }
        }
        if (coolTime - 8.0 > (double)MBotData.self.getTime() && coolTime <= (double)MBotData.self.getTime() && MBotData.enemy.distance > 250.0 && speed < 0.0) {
            MBotData.self.setMaxVelocity(0.0);
            nextPoint = MBotData.getLocation();
            MChassisDna5.go(nextPoint);
        } else {
            MBotData.self.setMaxVelocity(8.0);
        }
        ++speedCounter;
    }

    public void update(HitByBulletEvent e) {
        try {
            MBulletEnemy b = (MBulletEnemy)MBotData.enemy.bullets.get((e.getVelocity() + "00000").substring(0, 6));
            int indS = b.mySpeed;
            double dist = b.getDistance();
            double bearing = -e.getBearing();
            int ind = (int)MMath.clamp(30.0, 0.0, dist / e.getVelocity());
            int i = (int)Math.rint(bearing / 40.0) % 3;
            double d = b.power = b.power < 1.0 ? 1.0 : b.power;
            if (i == 0) {
                MChassisDna5.dnas[indS][ind].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness = (int)((double)MChassisDna5.dnas[indS][ind].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness - 1.0 * (4.8 * (dist / MBullet.getSpeed(b.power)) + (double)MChassisDna5.dnas[indS][ind].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness / 16.0));
            } else if (i == -1) {
                MChassisDna5.dnas[indS][ind].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness = (int)((double)MChassisDna5.dnas[indS][ind].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness - 1.3 * (dist / MBullet.getSpeed(b.power) + (double)MChassisDna5.dnas[indS][ind].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness / 14.0));
            } else if (i == 1) {
                MChassisDna5.dnas[MChassisDna5.indexS][ind].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness = (int)((double)MChassisDna5.dnas[MChassisDna5.indexS][ind].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness - 2.0 * (2.6 * (dist / MBullet.getSpeed(b.power)) + (double)MChassisDna5.dnas[indS][ind].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness / 13.0));
            } else if (i == -2) {
                MChassisDna5.dnas[indS][ind].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness = (int)((double)MChassisDna5.dnas[indS][ind].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness - 2.0 * ((Math.abs(MBotData.self.getVelocity()) + 1.0) * 2.6 * (dist / MBullet.getSpeed(b.power)) * (Math.abs(MBotData.self.getVelocity() / 3.0) + 1.0 + (double)MChassisDna5.dnas[indS][ind].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness / 13.0)));
            } else if (i == 2) {
                MChassisDna5.dnas[indS][ind].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness = (int)((double)MChassisDna5.dnas[indS][ind].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness - 2.5 * ((Math.abs(MBotData.self.getVelocity()) + 1.0) * 3.1 * (dist / MBullet.getSpeed(b.power)) * (Math.abs(MBotData.self.getVelocity() / 3.0) + 1.0) + (double)MChassisDna5.dnas[indS][ind].getChromosoom((String)new StringBuffer().append((int)i).append((String)"").toString()).fitness / 15.0));
            } else if (i == -3 || i == 3) {
                // empty if block
            }
            MBotData.enemy.bullets.remove(b.toString());
        }
        catch (Exception ex) {
            MBotData.err("SYSTEM:  Chassis    ... FAILED TIME: " + MBotData.self.getTime());
            MBotData.err("SYSTEM:   Err: No bullets matched! " + (e.getVelocity() + "00000").substring(0, 6) + " " + ex.toString());
        }
    }

    public static void go(MPoint toPoint) {
        double dist = MBotData.getLocation().distance(toPoint);
        double ang = MAngle.relative(MAngle.absolute(MBotData.getLocation(), toPoint) - MBotData.self.getHeading());
        if (MMath.abs(ang) > 90.0) {
            dist *= -1.0;
            ang = ang > 0.0 ? (ang -= 180.0) : (ang += 180.0);
        }
        MBotData.self.setTurnRight(ang + MMath.random(-1.0, 1.0));
        MBotData.self.setAhead(dist);
    }

    private static void kiss() {
        MBotData.self.setMaxVelocity(8.0);
        if (MBotData.enemy.distance > 350.0) {
            MChassisDna5.go(MPoint.validate(new MPoint(MBotData.enemy.x / 2.0, MBotData.enemy.y / 2.0)));
        } else {
            MChassisDna5.go(MBotData.enemy);
        }
    }

    static {
        dir = 1.0;
        coolTime = 0.0;
        speed = 0.0;
        index = 0;
        indexS = 0;
    }
}

