/*
 * Decompiled with CFR 0.152.
 */
package metal.shared;

import java.awt.geom.Rectangle2D;
import java.util.TreeMap;
import metal.shared.MAim;
import metal.shared.MBotData;
import metal.shared.MBullet;
import metal.shared.MGun;
import metal.shared.MMath;
import metal.shared.MPatternDir;
import metal.shared.MPatternLenght;
import metal.shared.MPatternSpeed;
import metal.shared.MPoint;
import metal.shared.MProbability;
import metal.shared.MRing;
import metal.shared.MScorer;
import metal.shared.MSituation;
import metal.shared.MZone;
import metal.shared.MZoneSelf;

public class MSimulator {
    static double headingAvg;
    private int now = 0;
    private Object[] o = null;
    private MRing r = null;
    private TreeMap rings = new TreeMap();
    private MSituation s = null;
    public static TreeMap situations;
    static TreeMap situationsOld;

    static {
        situations = new TreeMap();
        situationsOld = new TreeMap();
        headingAvg = 3.0;
    }

    public MSimulator() {
        MBotData.print("SYSTEM:  New Simulator ...");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public double calcProbabilities() {
        double d;
        MSituation s = this.getSituation();
        Object obj = situations.get(s.toString());
        s = obj == null ? s : (MSituation)obj;
        headingAvg = s.headingAvg;
        ++s.counter;
        try {
            if (!MAim.fire) {
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (obj == null) {
            d = MGun.prob;
            return d;
        }
        d = s.getProbabilityMax();
        return d;
    }

    private void calcRings() {
        this.now = (int)MBotData.enemy.time;
        this.o = this.rings.values().toArray();
        double i = 0.0;
        while (i < (double)this.o.length) {
            this.r = (MRing)this.o[(int)i];
            this.s = this.r.situation;
            this.s = (MSituation)situations.get(this.s.toString());
            MSituation mSituation = this.s = this.s == null ? this.r.situation : this.s;
            if (this.r.isHit(MBotData.enemy, this.now) && this.r.isValid()) {
                int j = 0;
                while ((double)j <= MProbability.NO) {
                    if ((double)j != this.r.getIndex()) {
                        try {
                            if (this.r.getIndex() != (double)(j + 1)) {
                                this.s.getProbability(j).rollingAvg(0.0);
                            }
                        }
                        catch (Exception ex) {
                            System.out.println("SYSTEM: time " + MBotData.self.getTime() + " Err: Sim calc ring " + ex + "\n " + j);
                        }
                    } else {
                        this.s.getProbability(this.r.getIndex()).rollingAvg(100.0, 200.0, this.r.power);
                        if (this.r.getIndex() + 1.0 < MProbability.NO) {
                            // empty if block
                        }
                    }
                    ++j;
                }
                this.rings.remove(new Long(this.r.time));
            }
            if (!this.r.isActive(MBotData.enemy, this.now)) {
                this.rings.remove(new Long(this.r.time));
            }
            situations.put(this.s.toString(), this.s);
            i += 1.0;
        }
    }

    public void calcShoot() {
        this.s = this.getSituation();
        MRing ring = new MRing(this.s);
        this.rings.put(new Long(ring.time), ring);
    }

    public MRing calcShootRing() {
        this.s = this.getSituation();
        MRing ring = new MRing(this.s);
        this.rings.put(new Long(ring.time), ring);
        return ring;
    }

    public void execute() {
        try {
            if (MBotData.self.getOthers() != 0) {
                this.calcRings();
            }
        }
        catch (Exception e) {
            MBotData.print("SYSTEM:   Simulator ... FAILD");
            System.out.println("SYSTEM: time " + MBotData.self.getTime() + " Err: Sim execute situations " + e);
            e.printStackTrace();
        }
    }

    public MSituation getSituation() {
        double accDiff = 0.0;
        MSituation situation = new MSituation();
        situation.patternSpeed = new MPatternSpeed(MBotData.enemy.getPatternSpeed());
        situation.patternLenght = new MPatternLenght(MBotData.enemy.getPatternLen());
        situation.patternDir = new MPatternDir(MBotData.enemy.getPatternDir() + (int)MBotData.enemy.getDirection());
        situation.zoneEnemyIndex = MZone.getNo(MBotData.enemy);
        situation.zoneSelfIndex = MZoneSelf.getNo(MBotData.getLocation());
        situation.bulletTimeIndex = MBullet.getTime() / 5;
        situation.angleIndex = (int)MMath.sign(MBotData.enemy.bearingDiff);
        situation.headingIndex = (int)Math.abs(Math.round(MBotData.enemy.bearing / 22.5));
        situation.speedIndex = (int)Math.abs(Math.round(MBotData.enemy.speed / 3.0));
        situation.bearingIndex = (int)Math.abs(Math.round(MBotData.enemy.bearingAvg));
        accDiff = Math.round(Math.abs(MBotData.enemy.speed) - Math.abs(MBotData.enemy.speedLast));
        situation.accIndex = accDiff != 0.0 ? (accDiff <= 0.0 ? 1 : 2) : 0;
        situation.coolIndex = (int)((1.0 + MBullet.power / 5.0) / MBotData.self.getGunCoolingRate());
        situation.accIndex = (int)accDiff;
        double moveTime = 0.0;
        moveTime = accDiff < 0.0 ? 5.0 : (accDiff > 0.0 ? 14.0 : (MBotData.enemy.speed == 0.0 ? 0.0 : (moveTime += 1.0)));
        int moveIndex = (int)(moveTime / 5.0);
        if (moveIndex >= 9) {
            moveIndex = 8;
        }
        situation.moveIndex = moveIndex;
        situation.speedLatIndex = (int)Math.abs(Math.round(MBotData.enemy.speedLat / 3.0));
        situation.speedAdvIndex = (int)MMath.sign(Math.round(MBotData.enemy.speedAdv / 3.0));
        double dist = 0.0;
        dist = MBotData.enemy.distance;
        situation.distanceIndex = (int)MMath.clamp(20.0, 0.0, dist / 140.0);
        Rectangle2D.Double r = new Rectangle2D.Double(18.0, 18.0, MBotData.self.getBattleFieldWidth() - 36.0, MBotData.self.getBattleFieldHeight() - 36.0);
        MPoint p = MPoint.getPoint(MBotData.enemy, MBotData.enemy.heading, MBotData.enemy.speed < 0.0 ? -80.0 : 80.0);
        situation.wallIndex = r.contains(p) ? 0 : 1;
        return situation;
    }

    public void init() {
        MBotData.print("SYSTEM:   Simulator ... OK");
        MScorer.init();
        this.rings = new TreeMap();
    }
}

