/*
 * Decompiled with CFR 0.152.
 */
package rdt.AgentSmith.Guns;

import rdt.AgentSmith.IRobot;
import rdt.AgentSmith.RobotHistory.RobotHistory;
import rdt.AgentSmith.RobotHistory.RobotSnapshot;
import rdt.AgentSmith.Stats.Average;
import rdt.AgentSmith.Stats.Counter;
import rdt.AgentSmith.Stats.IStats;
import rdt.AgentSmith.Stats.RollingAverage;

public abstract class Gun {
    public final RollingAverage RecentHitRate;
    public final Average AllTimeHitRate;
    public final Counter TotalHits;
    public final Counter TotalMisses;
    public final RollingAverage RecentDeltaAngle;
    public final Average AllTimeDeltaAngle;
    protected IRobot _robot;
    private RobotHistory _targetHistory;
    private long _firingTickOffset;
    private String _name;

    protected Gun(String name, IRobot robot, RobotHistory targetHistory, IStats stats, long firingTickOffset) {
        this._name = name;
        this._robot = robot;
        this.RecentHitRate = new RollingAverage("Guns : " + name + " : Recent Hit Rate", 10, 1.0);
        this.AllTimeHitRate = new Average("Guns : " + name + " : All Time Hit Rate");
        this.TotalHits = new Counter("Guns : " + name + " : Total Hits");
        this.TotalMisses = new Counter("Guns : " + name + " : Total Misses");
        this.RecentDeltaAngle = new RollingAverage("Guns : " + name + " : Recent Delta Angle", 10, 1.0);
        this.AllTimeDeltaAngle = new Average("Guns : " + name + " : All Time Delta Angle");
        this._targetHistory = targetHistory;
        this._firingTickOffset = firingTickOffset;
        stats.RegisterStat(this.RecentHitRate);
        stats.RegisterStat(this.AllTimeHitRate);
        stats.RegisterStat(this.TotalHits);
        stats.RegisterStat(this.TotalMisses);
        stats.RegisterStat(this.RecentDeltaAngle);
        stats.RegisterStat(this.AllTimeDeltaAngle);
    }

    public abstract double GetFiringAngle(double var1, double var3, long var5, double var7);

    public void RegisterHit(double deltaAngle) {
        this.RecentHitRate.Record(1.0);
        this.AllTimeHitRate.Record(1.0);
        this.RecentDeltaAngle.Record(deltaAngle);
        this.AllTimeDeltaAngle.Record(deltaAngle);
        this.TotalHits.Increment();
    }

    public void RegisterMiss(double deltaAngle) {
        this.RecentHitRate.Record(0.0);
        this.AllTimeHitRate.Record(0.0);
        this.RecentDeltaAngle.Record(deltaAngle);
        this.AllTimeDeltaAngle.Record(deltaAngle);
        this.TotalMisses.Increment();
    }

    protected RobotSnapshot GetFiringSnapshot(long firingTick) {
        long adjustedTick = firingTick + this._firingTickOffset;
        return this._targetHistory.GetSnapshotForTick(adjustedTick);
    }

    public String toString() {
        return String.format("%s : %d / %d (%.2f, %.2f) (%.2f, %.2f)", this._name, this.TotalHits.Value(), this.TotalHits.Value() + this.TotalMisses.Value(), this.AllTimeHitRate.GetAverage(), this.RecentHitRate.GetAverage(), this.AllTimeDeltaAngle.GetAverage(), this.RecentDeltaAngle.GetAverage());
    }
}

