/*
 * Decompiled with CFR 0.152.
 */
package rdt.AgentSmith.Utils;

import rdt.AgentSmith.IRobot;

public class RuleUtils {
    private static double _battleWidth;
    private static double _battleHeight;

    public static void Initialise(IRobot robot) {
        _battleWidth = robot.getBattleFieldWidth();
        _battleHeight = robot.getBattleFieldHeight();
    }

    public static double GetBulletVelocity(double bulletFirepower) {
        return 20.0 - 3.0 * bulletFirepower;
    }

    public static double GetClosestWallDistance(double x, double y) {
        return Math.min(Math.min(x, _battleWidth - x), Math.min(y, _battleHeight - y));
    }

    public static double GetDistanceToFurthestCorner(double x, double y) {
        double largestXDiff = Math.max(x, _battleWidth - x);
        double largestYDiff = Math.max(y, _battleHeight - y);
        return Math.sqrt(largestXDiff * largestXDiff + largestYDiff * largestYDiff);
    }

    public static boolean IsOutsideBattlefield(double x, double y, double padding) {
        if (x < padding) {
            return true;
        }
        if (y < padding) {
            return true;
        }
        if (x > _battleWidth - padding) {
            return true;
        }
        return y > _battleHeight - padding;
    }

    public static double GetDistanceToWall(double sourceX, double sourceY, double directionX, double directionY) {
        double distance = 0.0;
        boolean outsideOfBattlefield = false;
        double x = sourceX;
        double y = sourceY;
        double dLength = Math.sqrt(directionX * directionX + directionY * directionY);
        dLength *= 10.0;
        directionX *= 10.0;
        directionY *= 10.0;
        while (!outsideOfBattlefield) {
            outsideOfBattlefield = RuleUtils.IsOutsideBattlefield(x, y, 0.0);
            x += directionX;
            y += directionY;
            distance += dLength;
        }
        return distance;
    }
}

