/*
 * Decompiled with CFR 0.152.
 */
package fnc.bandit;

import fnc.bandit.Attractor;
import fnc.bandit.BulletAttractor;
import fnc.bandit.Force;
import fnc.bandit.Position;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class ForceField {
    Hashtable attractors;
    Hashtable bullet_attractors;
    double w;
    double h;
    PrintStream output;

    public ForceField(PrintStream printStream, double d, double d2) {
        this.w = d;
        this.h = d2;
        this.output = printStream;
        this.attractors = new Hashtable();
        this.bullet_attractors = new Hashtable();
    }

    public boolean inside(Position position) {
        return position.x >= 0.0 && position.x < this.w && position.y >= 0.0 && position.y < this.h;
    }

    public int count() {
        return this.attractors.size();
    }

    public Force force(Position position, long l) {
        Object k;
        Force force = new Force();
        Enumeration enumeration = this.attractors.keys();
        while (enumeration.hasMoreElements()) {
            k = enumeration.nextElement();
            Attractor attractor = (Attractor)this.attractors.get(k);
            force.add(attractor.force(position, l));
        }
        enumeration = this.bullet_attractors.keys();
        while (enumeration.hasMoreElements()) {
            k = enumeration.nextElement();
            BulletAttractor bulletAttractor = (BulletAttractor)this.bullet_attractors.get(k);
            Position position2 = bulletAttractor.getPosition(l);
            if (this.inside(position2)) continue;
            this.bullet_attractors.remove(bulletAttractor.getName());
        }
        return force;
    }

    public boolean contains(String string) {
        return this.attractors.containsKey(string);
    }

    public Attractor getAttractor(String string) {
        return (Attractor)this.attractors.get(string);
    }

    public void removeAttractor(String string) {
        this.attractors.remove(string);
    }

    public void addAttractor(Attractor attractor) {
        this.attractors.put(attractor.getName(), attractor);
    }

    public void addBulletAttractor(BulletAttractor bulletAttractor) {
        this.bullet_attractors.put(bulletAttractor.getName(), bulletAttractor);
    }

    public void countZero() {
        int n = this.attractors.size();
        Enumeration enumeration = this.attractors.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Attractor attractor = (Attractor)this.attractors.get(k);
            attractor.countZero();
            attractor.headcount = n;
        }
    }

    public Attractor findScanTarget(long l) {
        long l2 = l + 1L;
        long l3 = 0L;
        Attractor attractor = null;
        Enumeration enumeration = this.attractors.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Attractor attractor2 = (Attractor)this.attractors.get(k);
            l3 = attractor2.getScanTime();
            if (l3 >= l2) continue;
            l2 = l3;
            attractor = attractor2;
        }
        return attractor;
    }

    public Attractor findTarget(Position position, double d) {
        Attractor attractor;
        Object k;
        double d2 = 4.0 * this.h;
        double d3 = 0.0;
        Attractor attractor2 = null;
        Enumeration enumeration = this.attractors.keys();
        while (enumeration.hasMoreElements()) {
            k = enumeration.nextElement();
            attractor = (Attractor)this.attractors.get(k);
            double d4 = position.distance(attractor.getPosition());
            if (!(d4 < d2)) continue;
            d2 = d4;
        }
        enumeration = this.attractors.keys();
        while (enumeration.hasMoreElements()) {
            k = enumeration.nextElement();
            attractor = (Attractor)this.attractors.get(k);
            double d5 = attractor.bounty(d2, position, d);
            if (!(d5 > d3)) continue;
            d3 = d5;
            attractor2 = attractor;
        }
        return attractor2;
    }

    public void dump(PrintStream printStream) {
        Enumeration enumeration = this.attractors.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Attractor attractor = (Attractor)this.attractors.get(k);
            attractor.dump(printStream);
        }
    }
}

