/*
 * Decompiled with CFR 0.152.
 */
package pulsar.movement;

import java.awt.geom.Line2D;
import java.util.Map;
import java.util.Random;
import pulsar.PulsarMax;
import pulsar.movement.AbstractMovement;
import pulsar.util.RobotData;
import pulsar.util.Util;
import robocode.AdvancedRobot;
import robocode.HitRobotEvent;
import robocode.Robot;

public class AvoidRamMovement
extends AbstractMovement {
    private static final String NAME = "Avoid Ram Movement";
    private static int ramHits = 0;
    private AdvancedRobot robot;
    private static double mod = 0.5235987755982988;
    private static int timer = 0;
    private static Random random = new Random();

    public String getName() {
        return NAME;
    }

    public double getScore(AdvancedRobot robot, RobotData target, Map radar, Map wavesMap) {
        this.robot = robot;
        if (robot.getOthers() == 1 && AvoidRamMovement.isTargetRamming(robot, target)) {
            return 100.0;
        }
        return 0.0;
    }

    public static boolean isTargetRamming(AdvancedRobot robot, RobotData target) {
        double advancingvelocity = target.getAdvancingVelocityRelativeTo(PulsarMax.robotStats, 0);
        return target.getValue(target.energy) > 0.0 && (!((double)ramHits / (double)(robot.getRoundNum() + 1) < (double)2) || target.name.toLowerCase().indexOf("ramrod") >= 0 || target.name.toLowerCase().indexOf("nanodeath") >= 0 || target.getDistanceTo(PulsarMax.robotStats, 0) < (double)250 && !(advancingvelocity < (double)7));
    }

    public void doMovement(AdvancedRobot robot, RobotData target, Map radar, Map wavesMap) {
        if ((timer += -1) <= 0) {
            if (random.nextInt(8) > 0) {
                mod *= (double)-1;
            }
            timer = 5 + (int)(random.nextDouble() * (double)20);
        }
        double goalDirection = PulsarMax.robotStats.getAbsBearingTo(target, 0) - Math.PI + mod;
        if (!(target.getDistanceTo(PulsarMax.robotStats, 0) >= (double)80) || !(Math.abs(target.getValue(target.velocity)) >= 0.5) || AvoidRamMovement.distanceToWall((Robot)robot) < (double)150) {
            goalDirection = PulsarMax.robotStats.getAbsBearingTo(target, 0) - Util.sign(mod) * Math.PI * (double)2 / (double)3;
        }
        this.doMovement(robot, goalDirection, target, radar, wavesMap, true);
    }

    public void onHitRobot(HitRobotEvent e) {
        if (!e.isMyFault()) {
            ++ramHits;
        }
    }

    public static double distanceToWall(Robot robot) {
        double min = Double.MAX_VALUE;
        min = Math.min(min, Line2D.ptLineDist(0.0, 0.0, 0.0, robot.getBattleFieldHeight(), robot.getX(), robot.getY()));
        min = Math.min(min, Line2D.ptLineDist(0.0, 0.0, robot.getBattleFieldWidth(), 0.0, robot.getX(), robot.getY()));
        min = Math.min(min, Line2D.ptLineDist(0.0, robot.getBattleFieldHeight(), robot.getBattleFieldWidth(), robot.getBattleFieldHeight(), robot.getX(), robot.getY()));
        min = Math.min(min, Line2D.ptLineDist(robot.getBattleFieldWidth(), 0.0, robot.getBattleFieldWidth(), robot.getBattleFieldHeight(), robot.getX(), robot.getY()));
        return min;
    }
}

