/*
 * Decompiled with CFR 0.152.
 */
package pulsar.movement;

import apv.MovSim;
import apv.MovSimStat;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import pulsar.PulsarMax;
import pulsar.gf.AccSegmentation;
import pulsar.gf.DistanceSegmentation;
import pulsar.gf.GFUtil;
import pulsar.gf.LateralVelocitySegmentation;
import pulsar.gf.NullSegmentation;
import pulsar.gf.Segmentation;
import pulsar.gf.TimeSinceVelocityChangeSegmentation;
import pulsar.gf.VelocitySegmentation;
import pulsar.gf.WallSegmentation;
import pulsar.movement.AbstractMovement;
import pulsar.util.RobotData;
import pulsar.util.Util;
import pulsar.util.Wave;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;

public class WaveSurfing
extends AbstractMovement {
    public static final String NAME = "Wave Surfing";
    private static AdvancedRobot robot;
    private long timeForDirectionChange = 0;
    private static final int FACTOR_SEG = 27;
    private static final int LOW_VELOCITY = 0;
    private static final int MAX_VELOCITY = 8;
    private static Map radar;
    private static final double APPROACH_DISTANCE_CUTOFF = 250.0;
    private static final double APPROACH_ANGLE_CUTOFF = 4.0;
    private static int lastHitGFIndex;
    private boolean isRealStrategy = true;
    private static final double[] SEGMENTATION_WEIGHT;
    private static final boolean[] SEGMENTATION_USE_VISITS;
    private static final Map segmentationMap;
    private static int[][] segmentationSizes;
    private static final Segmentation[][] segmentation;
    private static final int[] ZERO_INT_ARRAY;
    private MovSimStat[] enemyPos = null;
    private long enemyPosTime = 0;
    private MovSimStat[] myPosDir1 = new MovSimStat[150];
    private MovSimStat[] myPosDirM1 = new MovSimStat[150];
    private long myPosTime = -1;
    private int[] moveTimesWallsAvoidDir1 = new int[150];
    private int[] moveTimesWallsAvoidDirM1 = new int[150];

    private static Segmentation[][] createSegmentation() {
        Segmentation[][] segmentation = new Segmentation[][]{{new NullSegmentation()}, {new DistanceSegmentation(1), new LateralVelocitySegmentation(0), new AccSegmentation(), new TimeSinceVelocityChangeSegmentation(3), new WallSegmentation(2)}, {new DistanceSegmentation(1), new LateralVelocitySegmentation(0), new AccSegmentation(), new WallSegmentation(2)}, {new DistanceSegmentation(1), new VelocitySegmentation(2), new AccSegmentation()}, {new DistanceSegmentation(1), new VelocitySegmentation(2), new AccSegmentation(), new TimeSinceVelocityChangeSegmentation(3)}};
        segmentationSizes = new int[segmentation.length][];
        int i = 0;
        while (i < segmentation.length) {
            segmentationMap.put(NAME + i, segmentation[i]);
            WaveSurfing.segmentationSizes[i] = new int[segmentation[i].length];
            int j = 0;
            while (j < segmentation[i].length) {
                WaveSurfing.segmentationSizes[i][j] = segmentation[i][j].getNoSegments();
                ++j;
            }
            ++i;
        }
        if (SEGMENTATION_WEIGHT.length != SEGMENTATION_USE_VISITS.length || SEGMENTATION_USE_VISITS.length != segmentation.length) {
            System.out.println("------- ERROR, segmentation setup size missmatch! -------");
        }
        return segmentation;
    }

    public boolean isRealStrategy() {
        return this.isRealStrategy;
    }

    public void setIsRealStrategy(boolean b) {
        this.isRealStrategy = b;
    }

    public String getName() {
        return NAME;
    }

    public double getScore(AdvancedRobot robot, RobotData target, Map radar, Map wavesMap) {
        WaveSurfing.robot = robot;
        WaveSurfing.radar = radar;
        if (robot.getOthers() <= 1) {
            return 70.0;
        }
        return 0.0;
    }

    public Map getSegmentationMap() {
        return segmentationMap;
    }

    public void doMovement(AdvancedRobot robot, RobotData currentTarget, Map radar, Map wavesMap) {
        double myDirection;
        long robotTime = robot.getTime();
        if (!PulsarMax.melee && robot.getOthers() == 1 && robot.getRoundNum() >= robot.getNumRounds() - 1 && currentTarget.getValue(currentTarget.energy) < (double)50 && currentTarget.bulletHits == 0) {
            robot.setMaxVelocity(0.0);
            return;
        }
        double bWidth = robot.getBattleFieldWidth();
        double bHeight = robot.getBattleFieldHeight();
        Point2D.Double circleLoc = null;
        circleLoc = new Point2D.Double(currentTarget.getValue(currentTarget.x), currentTarget.getValue(currentTarget.y));
        double optimalDistance = 250;
        double maxVelocity = 8;
        double newDirection = myDirection = PulsarMax.robotStats.getDirectionRelativeTo(currentTarget, 0);
        Iterator targetIter = radar.values().iterator();
        while (targetIter.hasNext()) {
            RobotData target = (RobotData)targetIter.next();
            if (!target.isAlive) continue;
            int i = 0;
            while (i < segmentation.length) {
                if (segmentationSizes[i].length == 1 && segmentationSizes[i][0] == 1) {
                    GFUtil.initHOA(target.name, NAME + i, segmentationSizes[i], 27);
                }
                ++i;
            }
            optimalDistance = robotTime - target.timeLastFire > (long)60 && target.getValue(target.energy) < 1.0 && target.getValue(target.energy) * (double)8 < robot.getEnergy() ? Math.max(optimalDistance, (double)250) : Math.max(optimalDistance, 510.0);
            double visitWeight = 0.0;
            if (WaveSurfing.useFlattener(target)) {
                visitWeight = 0.6;
            } else {
                optimalDistance = Math.max(optimalDistance, 410.0);
            }
            List waves = (List)wavesMap.get(target.name);
            if (waves != null && waves.size() > 0) {
                Iterator wavesIter = waves.iterator();
                Wave wave = null;
                float reverseSumMax = 0.0f;
                float continueSumMax = 0.0f;
                float continueSumLow = 0.0f;
                double robotX = robot.getX();
                double robotY = robot.getY();
                while (wavesIter.hasNext()) {
                    boolean old;
                    wave = (Wave)wavesIter.next();
                    double distLeft = wave.origin.distance(robotX, robotY) - Util.getBulletSpeed(wave.firePower) * (double)(robotTime - wave.time);
                    boolean bl = old = robot.getRoundNum() != target.dataFromRound || wave.time > robotTime + (long)100;
                    if (!(distLeft >= (double)-18) || old) {
                        wavesIter.remove();
                        if (wave.virtual) continue;
                        wave.removeBulletGraphics();
                        continue;
                    }
                    if (distLeft <= (double)18 && !wave.hit) {
                        int i2 = 0;
                        while (i2 < segmentation.length) {
                            if (SEGMENTATION_USE_VISITS[i2]) {
                                GFUtil.updateWaveVisit(NAME + i2, segmentationSizes[i2], target.name, robotX, robotY, wave, true, 27, 50, 5.0, 1.0);
                            }
                            ++i2;
                        }
                        wave.hit = true;
                    }
                    if (wave.realHit) continue;
                    wave.updateWave(robotTime);
                    PredictData forwardGuessFactorDataMax = this.predictMovement(robot, 8, myDirection, target, bWidth, bHeight, wave, optimalDistance);
                    PredictData reverseGuessFactorDataMax = this.predictMovement(robot, 8, -myDirection, target, bWidth, bHeight, wave, optimalDistance);
                    PredictData forwardGuessFactorDataLow = this.predictMovement(robot, 0.0, myDirection, target, bWidth, bHeight, wave, optimalDistance);
                    int[][] factorsAtFireTime = new int[segmentation.length][];
                    int i3 = 0;
                    while (i3 < segmentation.length) {
                        factorsAtFireTime[i3] = (int[])wave.gfIndexes.get(NAME + i3);
                        ++i3;
                    }
                    continueSumMax = (float)((double)continueSumMax + wave.firePower * this.getMovementValue(forwardGuessFactorDataMax, true, target, factorsAtFireTime, visitWeight));
                    reverseSumMax = (float)((double)reverseSumMax + wave.firePower * this.getMovementValue(reverseGuessFactorDataMax, true, target, factorsAtFireTime, visitWeight));
                    continueSumLow = (float)((double)continueSumLow + wave.firePower * this.getMovementValue(forwardGuessFactorDataLow, false, target, factorsAtFireTime, visitWeight));
                }
                if (continueSumMax > (float)1000000 && reverseSumMax > (float)1000000) {
                    continueSumLow = continueSumMax + reverseSumMax;
                }
                float[] reverseData = new float[]{reverseSumMax};
                float[] continueData = new float[]{continueSumMax, continueSumLow};
                float[] velocities = new float[]{8, 0.0f};
                int bestContinueIndex = 0;
                int bestReverseIndex = 0;
                int i4 = 1;
                while (i4 < velocities.length) {
                    if (reverseData.length > i4 && reverseData[bestReverseIndex] > reverseData[i4]) {
                        bestReverseIndex = i4;
                    }
                    if (continueData.length > i4 && continueData[bestContinueIndex] > continueData[i4]) {
                        bestContinueIndex = i4;
                    }
                    ++i4;
                }
                if (reverseData[bestReverseIndex] < continueData[bestContinueIndex]) {
                    newDirection = -myDirection;
                    this.timeForDirectionChange = robotTime;
                    maxVelocity = velocities[bestReverseIndex];
                    continue;
                }
                maxVelocity = velocities[bestContinueIndex];
                continue;
            }
            if (robot.getOthers() > 1) continue;
            Wave wave = target.createWave(PulsarMax.robotStats, target.lastFirePower, true, this.getSegmentationMap());
            wave.time += Util.getTimeToGunReady(target.lastFirePower, robotTime - target.timeLastFire);
            PredictData forwardGuessFactorDataMax = this.predictMovement(robot, 8, myDirection, target, bWidth, bHeight, wave, optimalDistance);
            PredictData reverseGuessFactorDataMax = this.predictMovement(robot, 8, -myDirection, target, bWidth, bHeight, wave, optimalDistance);
            if (reverseGuessFactorDataMax.timeLeft > forwardGuessFactorDataMax.timeLeft) {
                newDirection = -myDirection;
                this.timeForDirectionChange = robotTime;
            }
            maxVelocity = 8;
        }
        AbstractMovement.executeMove(this.setMovement(robot, maxVelocity, circleLoc, newDirection, optimalDistance), robot);
    }

    private boolean hasHitUsRecently(RobotData target) {
        return PulsarMax.time - target.timeLastHitUs < (long)120;
    }

    private boolean isClosestForTarget(RobotData target, Map radar) {
        double distance = PulsarMax.robotStats.getDistanceTo(target, 0) * 0.9;
        Iterator iter = radar.values().iterator();
        while (iter.hasNext()) {
            RobotData otherTarget = (RobotData)iter.next();
            if (!otherTarget.isAlive || otherTarget.name.equals(target.name) || !(target.getDistanceTo(otherTarget, 0) < distance)) continue;
            return false;
        }
        return true;
    }

    private double getMovementValue(PredictData guessFactorData, boolean closeIncrease, RobotData currentTarget, int[][] factorsAtFireTime, double visitWeight) {
        if (guessFactorData.hitFactors == null) {
            return 0.0;
        }
        double result = (double)(closeIncrease && currentTarget.getDistanceTo(PulsarMax.robotStats, 0) < 250.0 && guessFactorData.approachAngle > 4.0 ? 1000000 : 0) + (double)WaveSurfing.getGuessFactorValue(guessFactorData.hitFactors, true, lastHitGFIndex, currentTarget.name, factorsAtFireTime, guessFactorData.hitFactors[guessFactorData.hitFactors.length / 2], 1.0, 1.0, visitWeight, segmentationSizes, 27)[guessFactorData.hitFactors[guessFactorData.hitFactors.length / 2]] / Math.sqrt(10 * Math.max(guessFactorData.timeLeft, 1));
        return result;
    }

    public static boolean useFlattener(RobotData currentTarget) {
        return (double)currentTarget.bulletRangeHits / (double)(robot.getRoundNum() + 1) > (double)2 && !WaveSurfing.isHeadOnTargeter(currentTarget) && !WaveSurfing.isLinearTargeter(currentTarget) && !WaveSurfing.isReverseLinearTargeter(currentTarget);
    }

    private static boolean isHeadOnTargeter(RobotData enemy) {
        if (enemy.totalMovingForwardHits < 3) {
            return true;
        }
        float[] values = WaveSurfing.getGuessFactorValue(null, false, -1, enemy.name, null, -1, Double.POSITIVE_INFINITY, 1.0, 0.0, segmentationSizes, 27);
        double sumMiddle = 0.0;
        double total = 0.0;
        int width = (int)Math.round(3.857142857142857);
        int i = 0;
        while (i < values.length) {
            if (i >= values.length / 2 - width && i <= values.length / 2 + width) {
                sumMiddle += (double)values[i];
            }
            total += (double)values[i];
            ++i;
        }
        return !(total > 0.0) || !(sumMiddle / total <= 0.8);
    }

    private static boolean isLinearTargeter(RobotData enemy) {
        float[] values = WaveSurfing.getGuessFactorValue(null, false, -1, enemy.name, null, -1, Double.POSITIVE_INFINITY, 1.0, 0.0, segmentationSizes, 27);
        double sumForward = 0.0;
        double total = 0.0;
        int limit = values.length / 2 + 1;
        int i = 0;
        while (i < values.length) {
            if (i > limit) {
                sumForward += (double)values[i];
            }
            total += (double)values[i];
            ++i;
        }
        return !(sumForward / total <= 0.75);
    }

    private static boolean isReverseLinearTargeter(RobotData enemy) {
        float[] values = WaveSurfing.getGuessFactorValue(null, false, -1, enemy.name, null, -1, Double.POSITIVE_INFINITY, 1.0, 0.0, segmentationSizes, 27);
        double sumReverse = 0.0;
        double total = 0.0;
        int limit = values.length / 2 - 1;
        int i = 0;
        while (i < values.length) {
            if (i < limit) {
                sumReverse += (double)values[i];
            }
            total += (double)values[i];
            ++i;
        }
        return !(sumReverse / total <= 0.75);
    }

    private static float[] getGuessFactorValue(int[] currFactors, boolean botSize, int lastHitGFIndex, String target, int[][] gfIndex, int index, double pow, double hitWeight, double visitWeight, int[][] seg, int nFactors) {
        float[] values = new float[nFactors];
        float[] tmpValues = new float[nFactors];
        int i = 0;
        while (i < seg.length) {
            int j;
            if (gfIndex == null) {
                if (seg[i].length == 1 && seg[i][0] == 1) {
                    tmpValues = GFUtil.getGuessFactorValue(NAME + i, currFactors, botSize, lastHitGFIndex, target, ZERO_INT_ARRAY, index, pow, hitWeight, (SEGMENTATION_WEIGHT[i] != 0.0 ? 1.0 / SEGMENTATION_WEIGHT[i] : 0.0) * (SEGMENTATION_USE_VISITS[i] ? visitWeight : 0.0), seg[i], nFactors, true);
                    j = 0;
                    while (j < nFactors) {
                        int n = j;
                        values[n] = (float)((double)values[n] + SEGMENTATION_WEIGHT[i] * (double)tmpValues[j]);
                        ++j;
                    }
                }
            } else {
                tmpValues = GFUtil.getGuessFactorValue(NAME + i, currFactors, botSize, lastHitGFIndex, target, gfIndex[i], index, pow, hitWeight, (SEGMENTATION_WEIGHT[i] != 0.0 ? 1.0 / SEGMENTATION_WEIGHT[i] : 0.0) * (SEGMENTATION_USE_VISITS[i] ? visitWeight : 0.0), seg[i], nFactors, true);
                j = 0;
                while (j < nFactors) {
                    int n = j;
                    values[n] = (float)((double)values[n] + SEGMENTATION_WEIGHT[i] * (double)tmpValues[j]);
                    ++j;
                }
            }
            ++i;
        }
        return values;
    }

    private PredictData predictMovement(AdvancedRobot robot, double reqMaxVelocity, double direction, RobotData currentTarget, double bWidth, double bHeight, Wave wave, double optimalDistance) {
        PredictData data = new PredictData();
        data.hitFactors = GFUtil.getGuessFactorIndex(wave, robot.getX(), robot.getY(), false, 27);
        data.x = robot.getX();
        data.y = robot.getY();
        long time = PulsarMax.time;
        double totalDist = wave.origin.distance(robot.getX(), robot.getY());
        double distLeft = totalDist - Util.getBulletSpeed(wave.firePower) * (double)(time - wave.time);
        if (distLeft > (double)-10) {
            Point2D.Double circlePos = new Point2D.Double(currentTarget.getValue(currentTarget.x), currentTarget.getValue(currentTarget.y));
            AbstractMovement.Move moveDir1 = this.setMovement(robot, reqMaxVelocity, circlePos, 1.0, optimalDistance);
            AbstractMovement.Move moveDirM1 = this.setMovement(robot, reqMaxVelocity, circlePos, (double)-1, optimalDistance);
            MovSimStat[] myPos = null;
            myPos = direction > 0.0 ? this.myPosDir1 : this.myPosDirM1;
            if (this.myPosTime != time) {
                Arrays.fill(this.myPosDir1, null);
                Arrays.fill(this.myPosDirM1, null);
                this.myPosDir1[0] = MovSim.futurePos(1, robot.getX(), robot.getY(), robot.getVelocity(), moveDir1.maxVelocity, robot.getHeadingRadians(), moveDir1.ahead, moveDir1.turn, MovSim.defaultMaxTurnRate, bWidth, bHeight)[0];
                this.myPosDirM1[0] = MovSim.futurePos(1, robot.getX(), robot.getY(), robot.getVelocity(), moveDirM1.maxVelocity, robot.getHeadingRadians(), moveDirM1.ahead, moveDirM1.turn, MovSim.defaultMaxTurnRate, bWidth, bHeight)[0];
                this.myPosTime = PulsarMax.time;
            }
            int times = 0;
            totalDist = wave.origin.distance(myPos[0].x, myPos[0].y);
            distLeft = totalDist - Util.getBulletSpeed(wave.firePower) * (double)(++time - wave.time);
            if (this.enemyPos == null || this.enemyPosTime != time) {
                this.enemyPos = currentTarget.predictMovement(5);
                this.enemyPosTime = time;
            }
            while (distLeft > (double)-10 && times < 100) {
                ++time;
                if (myPos[++times] == null) {
                    moveDir1 = this.setMovement(this.myPosDir1[times - 1], reqMaxVelocity, circlePos, 1.0, optimalDistance);
                    this.moveTimesWallsAvoidDir1[times - 1] = moveDir1.timesWallsAvoid;
                    moveDirM1 = this.setMovement(this.myPosDirM1[times - 1], reqMaxVelocity, circlePos, (double)-1, optimalDistance);
                    this.moveTimesWallsAvoidDirM1[times - 1] = moveDirM1.timesWallsAvoid;
                    this.myPosDir1[times] = MovSim.futurePos(1, this.myPosDir1[times - 1].x, this.myPosDir1[times - 1].y, this.myPosDir1[times - 1].velocity, moveDir1.maxVelocity, this.myPosDir1[times - 1].heading, moveDir1.ahead, moveDir1.turn, MovSim.defaultMaxTurnRate, bWidth, bHeight)[0];
                    this.myPosDirM1[times] = MovSim.futurePos(1, this.myPosDirM1[times - 1].x, this.myPosDirM1[times - 1].y, this.myPosDirM1[times - 1].velocity, moveDirM1.maxVelocity, this.myPosDirM1[times - 1].heading, moveDirM1.ahead, moveDirM1.turn, MovSim.defaultMaxTurnRate, bWidth, bHeight)[0];
                }
                totalDist = wave.origin.distance(myPos[times].x, myPos[times].y);
                distLeft = totalDist - Util.getBulletSpeed(wave.firePower) * (double)(time - wave.time);
            }
            data.hitFactors = GFUtil.getGuessFactorIndex(wave, myPos[times].x, myPos[times].y, true, 27);
            data.approachAngle = direction > 0.0 ? (double)this.moveTimesWallsAvoidDir1[times] : (double)this.moveTimesWallsAvoidDirM1[times];
            data.x = myPos[times].x;
            data.y = myPos[times].y;
        }
        data.timeLeft = (int)(time - PulsarMax.time);
        return data;
    }

    public void onHitWall(HitWallEvent e) {
    }

    public void onBulletHit(BulletHitEvent e) {
    }

    public void onHitRobot(HitRobotEvent e) {
    }

    public void onHitByBullet(HitByBulletEvent e, Map wavesMap) {
        Bullet enemyBullet = e.getBullet();
        RobotData target = (RobotData)radar.get(enemyBullet.getName());
        Wave wave = this.doBulletHit(enemyBullet, wavesMap, true);
        if (wave != null && wave.origin.distance(enemyBullet.getX(), enemyBullet.getY()) > (double)150) {
            if (enemyBullet.getPower() > 0.1) {
                ++target.bulletRangeHits;
            }
            if (this.timeForDirectionChange < wave.time) {
                ++target.totalMovingForwardHits;
            }
        }
    }

    private Wave doBulletHit(Bullet enemyBullet, Map wavesMap, boolean botSize) {
        Wave theWave = null;
        RobotData target = (RobotData)radar.get(enemyBullet.getName());
        if (target != null) {
            List waves = (List)wavesMap.get(target.name);
            Iterator iter = waves.iterator();
            Wave wave = null;
            double minDist = Double.MAX_VALUE;
            while (iter.hasNext()) {
                double totalDist;
                double distLeft;
                wave = (Wave)iter.next();
                if (wave.virtual || !(minDist > (distLeft = Math.abs((totalDist = wave.origin.distance(enemyBullet.getX(), enemyBullet.getY())) - Util.getBulletSpeed(wave.firePower) * (double)(PulsarMax.time - wave.time)))) || !(distLeft < (double)50) || wave.realHit || !(Math.abs(wave.firePower - enemyBullet.getPower()) < 0.1)) continue;
                minDist = distLeft;
                theWave = wave;
            }
            if (theWave == null) {
                PulsarMax.println("COULD NOT FIND BULLET WAVE!!!!!!!!!!!!!!!!!!!!!!!!!");
            } else {
                theWave.realHit = true;
                int i = 0;
                while (i < segmentation.length) {
                    lastHitGFIndex = GFUtil.updateWaveHit(NAME + i, segmentationSizes[i], target.name, enemyBullet.getX(), enemyBullet.getY(), theWave, botSize, 27, 15, 5.0, 1.0);
                    ++i;
                }
            }
        } else {
            PulsarMax.println("Bullet from UNKNOWN target ignored!");
        }
        return theWave;
    }

    public void onBulletHitBullet(BulletHitBulletEvent e, Map wavesMap) {
        Bullet enemyBullet = e.getHitBullet();
        RobotData target = (RobotData)radar.get(enemyBullet.getName());
        if (target != null && Point2D.distance(enemyBullet.getX(), enemyBullet.getY(), target.getValue(target.x), target.getValue(target.y)) > (double)80) {
            this.doBulletHit(enemyBullet, wavesMap, false);
        }
    }

    static {
        radar = new HashMap();
        lastHitGFIndex = 13;
        SEGMENTATION_WEIGHT = new double[]{0.5, 1.0, 1.0, 1.0, 1.0};
        SEGMENTATION_USE_VISITS = new boolean[]{false, true, false, false, false};
        segmentationMap = new HashMap();
        segmentationSizes = null;
        segmentation = WaveSurfing.createSegmentation();
        ZERO_INT_ARRAY = new int[]{0};
    }

    class PredictData {
        int[] hitFactors;
        double approachAngle;
        int timeLeft;
        double x;
        double y;

        static /* synthetic */ WaveSurfing access$0(PredictData predictData) {
            return predictData.WaveSurfing.this;
        }
    }
}

