/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.util.AbstractList;
import java.util.Iterator;
import pa3k.BulletTracking;
import pa3k.DataStorage;
import pa3k.Log;
import pa3k.Opponent;
import pa3k.Position;
import pa3k.Stats;
import pa3k.StatsRadians;
import robocode.AdvancedRobot;

public class Aiming {
    protected AbstractList<BulletTracking> hits;
    protected AbstractList<BulletTracking> possibleHits;
    protected AbstractList<BulletTracking> misses;

    public Aiming(AdvancedRobot robot, String opponentName, boolean outgoing) {
        if (outgoing) {
            this.hits = DataStorage.getOutgoingHits(opponentName);
            this.misses = DataStorage.getOutgoingMisses(opponentName);
            this.possibleHits = DataStorage.getOutgoingPossibleHits(opponentName);
        } else {
            this.hits = DataStorage.getIncommingHits(opponentName);
            this.misses = DataStorage.getIncommingMisses(opponentName);
            this.possibleHits = DataStorage.getIncommingPossibleHits(opponentName);
        }
        Log.log(2, "Opponent " + opponentName + ", " + (outgoing ? "outgoing" : "incomming") + " aiming");
        Log.log(2, "  hits " + this.hits.size());
        Log.log(2, "  misses " + this.misses.size());
        Log.log(2, "  possible hits " + this.possibleHits.size());
    }

    public void hit(BulletTracking bt) {
        this.hits.add(bt);
    }

    public void miss(BulletTracking bt) {
        if (bt.getFiringAngle() == 0.0) {
            return;
        }
        this.misses.add(bt);
    }

    public void possibleHit(BulletTracking bt) {
        this.possibleHits.add(bt);
    }

    public BulletTracking getBestAimingAngle(Position source, Opponent target, double energy, long currentTime) {
        BulletTracking bt = new BulletTracking(energy, source, target, currentTime);
        try {
            bt.setFiringAngle(source.getDirectionTo(target.getLastPosition(currentTime)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bt;
    }

    public double[] getEscapeBins(BulletTracking bt) {
        double[] d = new double[1];
        return d;
    }

    public double getHittingRatio() {
        int missesCount = this.misses.size();
        if (missesCount == 0) {
            return 1.0;
        }
        return this.hits.size() / this.misses.size();
    }

    public void dumpStats() {
        Log.log(1, "Hits/misses " + this.hits.size() + "/" + this.misses.size() + ", " + (int)(100.0 * this.getHittingRatio()) + "%");
        StatsRadians firing = new StatsRadians();
        Iterator<BulletTracking> i = this.hits.iterator();
        long t = 0L;
        while (i.hasNext()) {
            ((Stats)firing).addValue(i.next().getFiringAngle(), t++);
        }
        Log.log(1, "Hitting angle: average " + (int)(firing.getD0Average() * 100.0) + "%, STD " + firing.getD0STD());
    }
}

