/*
 * Decompiled with CFR 0.152.
 */
package dk.predict;

import dk.Base;
import dk.Enemy;
import dk.Histogram;
import dk.Point;
import dk.Util;
import dk.predict.Factors;
import dk.predict.Predictor;
import dk.predict.Tracer;

public class Accelerational
extends Predictor {
    public Accelerational(Enemy enemy) {
        super(enemy);
    }

    public static Predictor.Factory factory() {
        return new Predictor.Factory(){

            public Predictor newInstance(Enemy e) {
                return new Accelerational(e);
            }
        };
    }

    protected Point getEstimatedPosition(Point start, double heading, double velocity, double acceleration, double headingChange, long timeInterval) {
        Point p = start;
        while (timeInterval > 0L) {
            if ((velocity += acceleration) > 8.0) {
                velocity = 8.0;
            } else if (velocity < -8.0) {
                velocity = -8.0;
            }
            heading += headingChange;
            heading = Util.normalizeHeading(heading);
            p = Util.applyHeading(p, heading, velocity);
            --timeInterval;
        }
        return p;
    }

    public Point getEstimatedPosition(Base robot, long time) {
        return this.getEstimatedPosition(this.enemy_.getPosition(), this.enemy_.getHeading(), this.enemy_.getVelocity(), this.enemy_.getAcceleration(), this.enemy_.getHeadingChange(), time - this.enemy_.getLastSeen());
    }

    public Point getEstimatedPosition(Base robot, Tracer t, long time) {
        Factors f = t.getFactors();
        return this.getEstimatedPosition(f.getPosition(), f.getHeading(), f.getVelocity(), f.getAcceleration(), f.getHeadingChange(), time - t.getStart());
    }

    public void tracerDidHit(Base robot, Tracer t, Histogram h) {
        Factors f = t.getFactors();
        double angle = this.getPredictedAngleForTracer(robot, t);
        double actualAngle = t.getActualAngle();
        double estimatedDistance = Util.range(t.getRobotStartPosition(), t.getTarget().getEstimatedPosition(robot.getTime()));
        double missDistance = Math.sin(Math.abs(angle - actualAngle)) * estimatedDistance;
        if (missDistance <= 18.0) {
            h.recordSuccess(this);
        } else {
            h.recordFailure(this);
        }
    }
}

