/*
 * Decompiled with CFR 0.152.
 */
package pa3k;

import java.util.ArrayList;
import java.util.List;
import pa3k.AngleUtils;
import pa3k.Change;
import pa3k.Log;
import pa3k.Opponent;
import pa3k.Position;
import pa3k.State;
import robocode.util.Utils;

class Simulation {
    protected List<State> states;
    protected List<Position> position;
    protected List<Boolean> dirChange;
    protected long startTime;
    private double heading;
    private double lastHeading;
    private int direction;
    private long lastOpponentSpeedChange;
    private long lastOpponentHitDelay;
    private long lastEnergyDropDelay;
    private double lastEnergyDrop;

    public Simulation(State[] stateArray, State state, long l, double d, Position position, Opponent opponent) {
        block2: {
            this.states = new ArrayList<State>(15);
            this.position = new ArrayList<Position>(15);
            this.dirChange = new ArrayList<Boolean>(15);
            Position position2 = opponent.getLastPosition();
            Log.log(4, "" + position2);
            position2.check();
            this.position.add(new Position(position2));
            this.states.add(state);
            this.dirChange.add(false);
            this.startTime = l;
            this.direction = opponent.getLastVelocity() > 0.0 ? 1 : -1;
            this.lastOpponentSpeedChange = opponent.getLastSpeedChange(l);
            this.lastEnergyDropDelay = -1L;
            this.lastOpponentHitDelay = 0L;
            this.lastEnergyDrop = 0.0;
            this.heading = 0.0;
            this.lastHeading = 0.0;
            try {
                this.heading = opponent.getLastHeading(l);
                this.lastHeading = opponent.getLastHeading(l - 1L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.simulateUntilHit(stateArray, 0, d, position, opponent);
    }

    public boolean isStillValid(long l, State state, boolean bl) {
        int n = (int)(l - this.startTime);
        if (n > 5) {
            return false;
        }
        if (n >= this.states.size()) {
            return true;
        }
        return this.states.get(n) == state && this.dirChange.get(n) == bl;
    }

    public Position expectedPosition(State[] stateArray, long l, double d, Position position, Opponent opponent) {
        int n = 0;
        int n2 = (int)(l - this.startTime);
        Position position2 = this.position.get(n);
        while (position2.distance(position) > d * (double)(n - n2)) {
            if (++n >= this.position.size()) {
                this.simulateUntilHit(stateArray, n2, d, position, opponent);
            }
            position2 = this.position.get(n);
        }
        return position2;
    }

    private void simulateUntilHit(State[] stateArray, int n, double d, Position position, Opponent opponent) {
        int n2 = this.position.size() - 1;
        Position position2 = new Position(this.position.get(n2));
        State state = this.states.get(n2);
        while (position2.distance(position) > d * (double)(n2 - n)) {
            double d2 = state.advancePosition(position2, this.heading, this.lastHeading, this.direction);
            this.lastHeading = this.heading;
            this.heading = d2;
            Object object = new Position(position2);
            ((Position)object).modify(1L, 140 * this.direction, this.heading);
            boolean bl = !((Position)object).isInBattlefield();
            object = state.advance(position2, this.lastOpponentSpeedChange, bl, this.lastOpponentHitDelay, this.lastEnergyDropDelay, this.lastEnergyDrop);
            boolean bl2 = false;
            if (object != null) {
                state = ((Change)object).getTargetState();
                if (((Change)object).isChangingDirection()) {
                    this.direction *= -1;
                    this.lastHeading = Utils.normalAbsoluteAngle((double)(this.lastHeading + 2.0 * AngleUtils.difference(this.heading, this.lastHeading)));
                    bl2 = true;
                }
            }
            ++n2;
            ++this.lastOpponentSpeedChange;
            ++this.lastOpponentHitDelay;
            ++this.lastEnergyDropDelay;
            this.position.add(new Position(position2));
            this.states.add(state);
            this.dirChange.add(bl2);
        }
    }
}

