/*
 * Decompiled with CFR 0.152.
 */
package xander.cat.radar;

import xander.core.Resources;
import xander.core.log.Log;
import xander.core.log.Logger;
import xander.core.math.RCMath;
import xander.core.radar.Radar;
import xander.core.radar.RadarController;
import xander.core.track.Snapshot;
import xander.core.track.SnapshotHistory;

public class BasicRadar
implements Radar {
    private static final Log log = Logger.getLog(BasicRadar.class);
    private SnapshotHistory snapshotHistory;
    private double searchSweep;
    private double focusSweep;
    private long focusTargetTime;

    public BasicRadar(double searchSweepDegrees, double focusSweepDegrees) {
        this.searchSweep = searchSweepDegrees;
        this.focusSweep = focusSweepDegrees;
        this.snapshotHistory = Resources.getSnapshotHistory();
    }

    @Override
    public String getName() {
        return "Basic Radar";
    }

    @Override
    public void onRoundBegin() {
    }

    @Override
    public Snapshot search(RadarController radarController) {
        double degrees = this.searchSweep;
        Snapshot opp = this.snapshotHistory.getLastOpponentScanned();
        if (opp != null && opp.getTime() != this.focusTargetTime) {
            this.focusTargetTime = opp.getTime();
            Snapshot me = this.snapshotHistory.getMySnapshot(opp.getTime(), false);
            if (me == null) {
                log.error("Unable to retrieve my history for time " + opp.getTime() + "; unable to focus on target!");
            } else {
                double[] nextOppXY = opp.getNextXY();
                double[] nextMyXY = me.getNextXY();
                double targetRadarHeading = RCMath.getRobocodeAngle(nextOppXY[0] - nextMyXY[0], nextOppXY[1] - nextMyXY[1]);
                degrees = RCMath.getTurnAngle(radarController.getRadarHeadingDegrees(), targetRadarHeading);
                degrees = degrees < 0.0 ? (degrees -= this.focusSweep / 2.0) : (degrees += this.focusSweep / 2.0);
            }
        } else {
            opp = null;
        }
        radarController.setTurnRadarRightDegrees(degrees);
        return opp;
    }
}

