/*
 * Decompiled with CFR 0.152.
 */
package xander.cat.scenario;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import xander.core.Resources;
import xander.core.RobotProxy;
import xander.core.Scenario;
import xander.core.event.TurnListener;
import xander.core.gun.Aim;
import xander.core.gun.XanderGun;
import xander.core.math.RCMath;
import xander.core.track.Snapshot;
import xander.core.track.SnapshotHistory;

public class CircularDriveScenario
implements Scenario,
TurnListener {
    private XanderGun xanderGun;
    private RobotProxy robotProxy;
    private SnapshotHistory snapshotHistory;
    private Rectangle2D.Double bounds;
    private int referenceCount;
    private double referenceTurnLow;
    private double referenceTurnHigh;
    private double lastHeading;
    private int applyCount;
    private int notApplyCount;

    public CircularDriveScenario(XanderGun xanderGun) {
        this.xanderGun = xanderGun;
        this.robotProxy = Resources.getRobotProxy();
        this.snapshotHistory = Resources.getSnapshotHistory();
        this.bounds = RCMath.shrink(Resources.getRobotProxy().getBattleFieldSize(), 20.0);
        Resources.getRobotEvents().addTurnListener(this);
    }

    @Override
    public void onTurnBegin() {
        Snapshot opponent = this.snapshotHistory.getLastOpponentScanned();
        if (opponent != null) {
            double referenceTurn = RCMath.getTurnAngle(this.lastHeading, opponent.getHeadingRoboDegrees());
            if (this.referenceCount < 100 && referenceTurn != 0.0 && referenceTurn <= this.referenceTurnHigh && referenceTurn >= this.referenceTurnLow) {
                ++this.referenceCount;
            } else {
                if (this.referenceCount > 2 && this.robotProxy.getOthers() > 0) {
                    this.referenceCount -= 2;
                }
                this.referenceTurnLow = referenceTurn - 0.1;
                this.referenceTurnHigh = referenceTurn + 0.1;
            }
            this.lastHeading = opponent.getHeadingRoboDegrees();
        }
    }

    public double getAppliesPercentage() {
        double total = this.applyCount + this.notApplyCount;
        return total > 0.0 ? (double)this.applyCount / total : 0.0;
    }

    @Override
    public void onTurnEnd() {
    }

    @Override
    public boolean applies() {
        if (this.referenceCount >= 60) {
            Snapshot opponent = this.snapshotHistory.getLastOpponentScanned();
            Snapshot pOpponent = null;
            Snapshot myself = null;
            Aim aim = null;
            if (opponent != null) {
                pOpponent = this.snapshotHistory.getSnapshot(opponent.getName(), opponent.getTime() - 1L, false);
                myself = this.snapshotHistory.getMySnapshot();
                aim = this.xanderGun.getAim(opponent, myself);
            }
            if (aim != null && pOpponent != null) {
                Point2D.Double oppP = new Point2D.Double(opponent.getX(), opponent.getY());
                double oppV = opponent.getVelocity();
                double oppH = opponent.getHeadingRoboDegrees();
                double oppTR = RCMath.getTurnAngle(pOpponent.getHeadingRoboDegrees(), opponent.getHeadingRoboDegrees());
                double bulletDistance = 0.0;
                double oppDistance = opponent.getDistance();
                while (bulletDistance < oppDistance) {
                    oppP = RCMath.getLocation(oppP.x, oppP.y, oppV, oppH += oppTR);
                    if (!this.bounds.contains(oppP)) {
                        ++this.notApplyCount;
                        return false;
                    }
                    bulletDistance += aim.getBulletVelocity();
                    oppDistance = RCMath.getDistanceBetweenPoints(myself.getLocation(), oppP);
                }
                ++this.applyCount;
                return true;
            }
        }
        ++this.notApplyCount;
        return false;
    }
}

