/*
 * Decompiled with CFR 0.152.
 */
package xander.core.gun;

import xander.core.Resources;
import xander.core.RobotProxy;
import xander.core.gun.Aim;
import xander.core.gun.Gun;
import xander.core.gun.GunController;
import xander.core.math.RCMath;
import xander.core.track.Snapshot;

public abstract class AbstractGun
implements Gun {
    private long nextFireTick;
    private double nextFirePower;
    protected RobotProxy robotProxy = Resources.getRobotProxy();

    @Override
    public void onRoundBegin() {
        this.nextFireTick = 0L;
    }

    @Override
    public boolean fireAt(Snapshot target, Snapshot myself, GunController gunController) {
        boolean bulletFired = false;
        if (gunController.isGunReadyToFire() && this.robotProxy.getTime() == this.nextFireTick) {
            gunController.setFireBullet(this, myself, target, this.nextFirePower);
            bulletFired = true;
        }
        if (gunController.getPreciseTimeUntilReadyToFire() < 2.0) {
            Aim aim = this.getAim(target, myself);
            if (aim != null) {
                this.nextFireTick = this.robotProxy.getTime() + 1L;
                this.nextFirePower = aim.getFirePower();
                double turn = RCMath.getTurnAngle(this.robotProxy.getGunHeadingDegrees(), aim.getHeading());
                if (turn != 0.0) {
                    gunController.setTurnGunRightDegrees(turn);
                }
            }
        } else {
            double oppHeading = RCMath.getRobocodeAngle(myself.getLocation(), target.getLocation());
            double turn = RCMath.getTurnAngle(this.robotProxy.getGunHeadingDegrees(), oppHeading);
            gunController.setTurnGunRightDegrees(turn);
        }
        return bulletFired;
    }
}

