/*
 * Decompiled with CFR 0.152.
 */
package xander.core.gun.targeter;

import xander.core.Resources;
import xander.core.gun.targeter.Targeter;
import xander.core.math.Circular;
import xander.core.math.RCMath;
import xander.core.math.VelocityVector;
import xander.core.track.Snapshot;
import xander.core.track.SnapshotHistory;
import xander.core.track.Wave;

public class CircularTargeter
implements Targeter {
    private double[] centerPoint;
    private double aim;
    private SnapshotHistory snapshotHistory = Resources.getSnapshotHistory();
    private Snapshot firstSnapshot;
    private Snapshot secondSnapshot;
    private int minTimeAgo = 2;
    private double minHeadingChange = 4.0;
    private int maxTimeAgo = 30;

    @Override
    public String getTargetingType() {
        return "Circular";
    }

    @Override
    public boolean canAimAt(Snapshot target) {
        this.centerPoint = null;
        if (target != null) {
            Snapshot olderSnapshot = null;
            long checkTime = target.getTime() - (long)this.minTimeAgo;
            while (checkTime > target.getTime() - (long)this.maxTimeAgo) {
                double headingChange;
                olderSnapshot = this.snapshotHistory.getSnapshot(target.getName(), checkTime, false);
                if (olderSnapshot != null && Math.abs(headingChange = RCMath.getTurnAngle(olderSnapshot.getHeadingRoboDegrees(), target.getHeadingRoboDegrees())) >= this.minHeadingChange) break;
                --checkTime;
            }
            if (olderSnapshot != null) {
                this.centerPoint = Circular.getCenterPoint(target, olderSnapshot);
            }
            this.secondSnapshot = olderSnapshot;
        }
        this.firstSnapshot = target;
        return this.centerPoint != null;
    }

    @Override
    public double getAim(Snapshot target, Snapshot myself, Wave wave) {
        if (this.centerPoint == null) {
            return -1.0;
        }
        VelocityVector targetVector = Circular.calculateTrajectory(target, myself.getX(), myself.getY(), this.centerPoint, wave.getBulletVelocity(), target.getTime());
        this.aim = targetVector == null ? -1.0 : targetVector.getRoboAngle();
        return this.aim;
    }
}

