/*
 * Decompiled with CFR 0.152.
 */
package xander.gfws.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import xander.core.Resources;
import xander.core.event.MyWaveListener;
import xander.core.event.OpponentWaveListener;
import xander.core.event.RoundBeginListener;
import xander.core.track.Snapshot;
import xander.core.track.Wave;
import xander.core.track.XBulletWave;
import xander.gfws.processor.FactorArrayProcessor;

public abstract class CachingFactorArrayProcessor
implements FactorArrayProcessor,
RoundBeginListener,
MyWaveListener,
OpponentWaveListener {
    private Map<Wave, double[]> factorArrayCache = new HashMap<Wave, double[]>();
    private List<double[]> availableFactorArrays = new ArrayList<double[]>();
    protected int factors;

    public CachingFactorArrayProcessor(int factors) {
        this.factors = factors;
        Resources.getRobotEvents().addRoundBeginListener(this);
        Resources.getWaveHistory().addMyWaveListener(this);
        Resources.getWaveHistory().addOpponentWaveListener(this);
    }

    protected abstract void fillFactorArray(double[] var1, Wave var2, double var3, double var5);

    @Override
    public int getFactors() {
        return this.factors;
    }

    @Override
    public double[] getFactorArray(Wave surfWave, double currentMinFactorAngle, double currentMaxFactorAngle) {
        double[] factorArray = this.factorArrayCache.get(surfWave);
        if (factorArray == null) {
            factorArray = this.availableFactorArrays.size() > 0 ? this.availableFactorArrays.remove(this.availableFactorArrays.size() - 1) : new double[this.factors];
            this.fillFactorArray(factorArray, surfWave, currentMinFactorAngle, currentMaxFactorAngle);
            this.factorArrayCache.put(surfWave, factorArray);
        }
        return factorArray;
    }

    private void recycleFactorArray(Wave wave) {
        double[] factorArray = this.factorArrayCache.remove(wave);
        if (factorArray != null) {
            Arrays.fill(factorArray, 0.0);
            this.availableFactorArrays.add(factorArray);
        }
    }

    @Override
    public void oppWaveCreated(Wave wave) {
    }

    @Override
    public void oppWaveHitBullet(Wave wave, Bullet oppBullet) {
    }

    @Override
    public void oppWaveHit(Wave wave) {
    }

    @Override
    public void oppNextWaveToHit(Wave wave) {
    }

    @Override
    public void oppBulletHit(Wave wave, HitByBulletEvent hitByBulletEvent) {
    }

    @Override
    public void oppWavePassing(Wave wave) {
    }

    @Override
    public void oppWavePassed(Wave wave) {
    }

    @Override
    public void oppWaveUpdated(Wave wave) {
        this.recycleFactorArray(wave);
    }

    @Override
    public void oppWaveDestroyed(Wave wave) {
        this.recycleFactorArray(wave);
    }

    @Override
    public void myWaveCreated(XBulletWave wave) {
    }

    @Override
    public void myWaveHitBullet(XBulletWave wave, Bullet myBullet) {
    }

    @Override
    public void myWaveHit(XBulletWave wave, Snapshot opponentSnapshot) {
    }

    @Override
    public void myBulletHit(XBulletWave wave, BulletHitEvent bulletHitEvent) {
    }

    @Override
    public void myWavePassing(XBulletWave wave, Snapshot opponentSnapshot) {
    }

    @Override
    public void myWavePassed(XBulletWave wave, Snapshot opponentSnapshot) {
    }

    @Override
    public void myWaveDestroyed(XBulletWave wave) {
        this.recycleFactorArray(wave);
    }

    @Override
    public void onRoundBegin() {
        HashSet<Wave> leftOvers = new HashSet<Wave>();
        leftOvers.addAll(this.factorArrayCache.keySet());
        for (Wave wave : leftOvers) {
            this.recycleFactorArray(wave);
        }
    }
}

