/*
 * Decompiled with CFR 0.152.
 */
package csm.util;

public class Geometry {
    private static double PI = Math.PI;

    public static double shortestBearingRadians(double angle) {
        if (angle > PI) {
            angle -= 2.0 * PI;
        }
        if (angle < -PI) {
            angle += 2.0 * PI;
        }
        return angle;
    }

    public static double shortestHeadingRadians(double angle) {
        if (angle > 2.0 * PI) {
            angle -= 2.0 * PI;
        }
        if (angle < 0.0) {
            angle += 2.0 * PI;
        }
        return angle;
    }

    public static double range(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Math.sqrt(xo * xo + yo * yo);
        return h;
    }

    public static double absoluteBearingRadians(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double h = Geometry.range(x1, y1, x2, y2);
        double absoluteBearing = 0.0;
        if (xo > 0.0 && yo > 0.0) {
            absoluteBearing = Math.asin(xo / h);
        }
        if (xo > 0.0 && yo < 0.0) {
            absoluteBearing = Math.PI - Math.asin(xo / h);
        }
        if (xo < 0.0 && yo < 0.0) {
            absoluteBearing = Math.PI + Math.asin(-xo / h);
        }
        if (xo < 0.0 && yo > 0.0) {
            absoluteBearing = Math.PI * 2 - Math.asin(-xo / h);
        }
        return absoluteBearing;
    }
}

