/*
 * Decompiled with CFR 0.152.
 */
package florent.XSeries.movement;

import florent.XSeries.movement.AntiGravity;
import florent.XSeries.movement.BlackboardMovement;
import florent.XSeries.movement.FatalityMovement;
import florent.XSeries.movement.MinimumRisk;
import florent.XSeries.movement.Mirror;
import florent.XSeries.movement.MovementStrategy;
import florent.XSeries.movement.MovementType;
import florent.XSeries.movement.NullMovement;
import florent.XSeries.movement.Ram;
import florent.XSeries.movement.ToadMovementAdapter;
import florent.XSeries.movement.WaveSurfing;
import florent.XSeries.team.Xmen;
import florent.XSeries.utils.RobocodeTools;
import java.util.EnumMap;
import robocode.AdvancedRobot;

public class MovementFactory {
    private EnumMap<MovementType, MovementStrategy> strategies = new EnumMap(MovementType.class);
    private Xmen me;
    private static MovementFactory instance;
    static /* synthetic */ Class class$0;

    private MovementFactory() {
    }

    public static MovementFactory getInstance() {
        if (instance == null) {
            instance = new MovementFactory();
        }
        return instance;
    }

    public MovementStrategy getStrategy(MovementType key) {
        MovementStrategy strategy;
        if (this.strategies.containsKey((Object)key)) {
            return this.strategies.get((Object)key);
        }
        switch (key) {
            case ANTIGRAVITYMOVEMENT: {
                strategy = new AntiGravity(this.me);
                this.strategies.put(key, strategy);
                break;
            }
            case BLACKBOARDMOVEMENT: {
                strategy = new BlackboardMovement();
                this.strategies.put(key, strategy);
                break;
            }
            case FATALITYMOVEMENT: {
                strategy = new FatalityMovement(this.me);
                this.strategies.put(key, strategy);
                break;
            }
            case MINIMUMRISKMOVEMENT: {
                strategy = new MinimumRisk();
                this.strategies.put(key, strategy);
                break;
            }
            case MIRRORMOVEMENT: {
                strategy = new Mirror(this.me);
                this.strategies.put(key, strategy);
                break;
            }
            case NULLMOVEMENT: {
                strategy = new NullMovement();
                this.strategies.put(key, strategy);
                break;
            }
            case RAMMOVEMENT: {
                strategy = new Ram(this.me);
                this.strategies.put(key, strategy);
                break;
            }
            case TOADMOVEMENT: {
                strategy = new ToadMovementAdapter((AdvancedRobot)this.me);
                this.strategies.put(key, strategy);
                break;
            }
            case WAVESURFINGMOVEMENT: {
                strategy = new WaveSurfing(this.me);
                this.strategies.put(key, strategy);
                break;
            }
            default: {
                RobocodeTools.log("Unknown key " + this.getClass().getName());
                strategy = null;
            }
        }
        return strategy;
    }

    public void setMe(Xmen me) {
        this.me = me;
    }
}

