/*
 * Decompiled with CFR 0.152.
 */
package florent.XSeries.utils;

import florent.XSeries.utils.RobocodeTools;
import florent.XSeries.utils.VisitRecorder;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import robocode.Condition;
import robocode.util.Utils;

public abstract class Wave
extends Condition {
    public Point2D.Double gunLocation;
    protected Point2D.Double startLocation;
    protected int bearingDirection;
    public double velocity;
    public double distance;
    public double fireTime;

    public void init(Point2D.Double gun, Point2D.Double target, int bearingDirection, double power, double fireTime) {
        this.gunLocation = new Point2D.Double(gun.x, gun.y);
        this.startLocation = new Point2D.Double(target.x, target.y);
        this.bearingDirection = bearingDirection;
        this.fireTime = fireTime;
        this.velocity = RobocodeTools.bulletVelocity(power);
        this.distance = gun.distance(target);
    }

    protected abstract Point2D.Double getTargetLocation();

    protected boolean passed(double offset, double time, Point2D.Double location) {
        return this.distanceToImpact(location, time) < offset;
    }

    public double distanceToImpact(Point2D.Double location, double time) {
        return location.distance(this.gunLocation) - (time - this.fireTime) * this.velocity;
    }

    protected void registerVisit(double gf, double lowGf, double highGf, double[] gfs) {
        this.getRecorder().registerVisit(gf, lowGf, highGf, gfs);
    }

    protected abstract VisitRecorder getRecorder();

    protected double visitingGf(Point2D.Double location) {
        double goodAngle = Utils.normalRelativeAngle((double)(RobocodeTools.absoluteBearing(this.gunLocation, this.getTargetLocation()) - RobocodeTools.absoluteBearing(this.gunLocation, this.startLocation)));
        return goodAngle / (double)this.bearingDirection / this.maxEscapeAngle();
    }

    protected double visitingGf() {
        return this.visitingGf(this.getTargetLocation());
    }

    public double halfWidth(double distance) {
        return Math.abs(Math.atan(18.0 / distance) / (double)this.bearingDirection / this.maxEscapeAngle());
    }

    protected double lowGf(double gf, double distance) {
        return RobocodeTools.bindToRange(gf - this.halfWidth(distance), -1.0, 1.0);
    }

    protected double highGf(double gf, double distance) {
        return RobocodeTools.bindToRange(gf + this.halfWidth(distance), -1.0, 1.0);
    }

    protected double maxEscapeAngle() {
        return RobocodeTools.maxEscapeAngle(this.velocity);
    }

    protected int mostVisitedIndex(double[] gfs) {
        double distance = this.gunLocation.distance(this.startLocation);
        int bestGF = (gfs.length - 1) / 2;
        int GF_ONE = gfs.length - 1;
        double bestVal = 0.0;
        int halfWidth = (int)Math.floor(Math.atan(18.0 / distance) * (double)GF_ONE);
        int gf = GF_ONE;
        while (gf > 0) {
            double tmp = 0.0;
            int i = Math.max(1, gf - halfWidth);
            while (i <= Math.min(gf + halfWidth, GF_ONE)) {
                if ((tmp += gfs[i]) > bestVal) {
                    bestGF = gf;
                    bestVal = tmp;
                }
                ++i;
            }
            --gf;
        }
        return bestGF;
    }

    public double wallDistance(double direction, Rectangle2D fieldRectangle) {
        return this.wallDistance(direction, fieldRectangle, this.startLocation);
    }

    public double wallDistance(double direction, Rectangle2D fieldRectangle, Point2D.Double startLocation) {
        double targetDistance = this.distanceToImpact(startLocation, this.fireTime);
        double d = 0.0;
        while (d < 2.0) {
            if (!fieldRectangle.contains(RobocodeTools.projectMotion(this.gunLocation, RobocodeTools.absoluteBearing(this.gunLocation, startLocation) + (double)this.bearingDirection * direction * d, targetDistance))) {
                return d;
            }
            d += 0.01;
        }
        return 2.0;
    }

    protected double travelTime(Point2D.Double location, double time) {
        return this.distanceToImpact(location, time) / this.velocity;
    }

    public Point2D.Double getGunLocation() {
        return this.gunLocation;
    }
}

