/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp;

import dmonner.xlbp.compound.FunctionCompound;
import dmonner.xlbp.compound.LinearCompound;
import dmonner.xlbp.compound.LinearTargetCompound;
import dmonner.xlbp.compound.LogisticCompound;
import dmonner.xlbp.compound.SimpleCompound;
import dmonner.xlbp.compound.SumOfSquaresTargetCompound;
import dmonner.xlbp.compound.TanhCompound;
import dmonner.xlbp.compound.TanhTargetCompound;
import dmonner.xlbp.compound.TargetCompound;
import dmonner.xlbp.compound.WeightedCompound;
import dmonner.xlbp.compound.XEntropyTargetCompound;
import dmonner.xlbp.layer.FunctionLayer;
import dmonner.xlbp.layer.LinearLayer;
import dmonner.xlbp.layer.LogisticLayer;
import dmonner.xlbp.layer.TanhLayer;

public enum Function {
    LOGISTIC,
    LINEAR,
    TANH,
    NONE;


    public static WeightedCompound compound(String fcn, String name, int size) {
        if (fcn.endsWith("-ub")) {
            return Function.compound(fcn.substring(0, fcn.length() - 3), name, size, false);
        }
        return Function.compound(fcn, name, size, true);
    }

    public static WeightedCompound compound(String fcn, String name, int size, boolean biases) {
        String ufcn = fcn.toUpperCase();
        if (NONE.toString().startsWith(ufcn)) {
            return new SimpleCompound(name, size);
        }
        if (LOGISTIC.toString().startsWith(ufcn)) {
            return new LogisticCompound(name, size, biases);
        }
        if (LINEAR.toString().startsWith(ufcn)) {
            return new LinearCompound(name, size, biases);
        }
        if (TANH.toString().startsWith(ufcn)) {
            return new TanhCompound(name, size, biases);
        }
        throw new IllegalArgumentException("Unrecognized function type: " + fcn);
    }

    public static FunctionCompound fcompound(String fcn, String name, int size) {
        if (fcn.endsWith("-ub")) {
            return Function.fcompound(fcn.substring(0, fcn.length() - 3), name, size, false);
        }
        return Function.fcompound(fcn, name, size, true);
    }

    public static FunctionCompound fcompound(String fcn, String name, int size, boolean biases) {
        String ufcn = fcn.toUpperCase();
        if (NONE.toString().startsWith(ufcn)) {
            return null;
        }
        if (LOGISTIC.toString().startsWith(ufcn)) {
            return new LogisticCompound(name, size, biases);
        }
        if (LINEAR.toString().startsWith(ufcn)) {
            return new LinearCompound(name, size, biases);
        }
        if (TANH.toString().startsWith(ufcn)) {
            return new TanhCompound(name, size, biases);
        }
        throw new IllegalArgumentException("Unrecognized function type: " + fcn);
    }

    public static FunctionLayer layer(String fcn, String name, int size) {
        String ufcn = fcn.toUpperCase();
        if (NONE.toString().startsWith(ufcn)) {
            return null;
        }
        if (LOGISTIC.toString().startsWith(ufcn)) {
            return new LogisticLayer(name, size);
        }
        if (LINEAR.toString().startsWith(ufcn)) {
            return new LinearLayer(name, size);
        }
        if (TANH.toString().startsWith(ufcn)) {
            return new TanhLayer(name, size);
        }
        throw new IllegalArgumentException("Unrecognized function type: " + fcn);
    }

    public static float max(String fcn) {
        String ufcn = fcn.toUpperCase();
        if (NONE.toString().startsWith(ufcn)) {
            return 0.0f;
        }
        if (LOGISTIC.toString().startsWith(ufcn)) {
            return 1.0f;
        }
        if (LINEAR.toString().startsWith(ufcn)) {
            return Float.POSITIVE_INFINITY;
        }
        if (TANH.toString().startsWith(ufcn)) {
            return 1.0f;
        }
        throw new IllegalArgumentException("Unrecognized function type: " + fcn);
    }

    public static float mid(String fcn) {
        String ufcn = fcn.toUpperCase();
        if (NONE.toString().startsWith(ufcn)) {
            return 0.0f;
        }
        if (LOGISTIC.toString().startsWith(ufcn)) {
            return 0.5f;
        }
        if (LINEAR.toString().startsWith(ufcn)) {
            return 0.0f;
        }
        if (TANH.toString().startsWith(ufcn)) {
            return 0.0f;
        }
        throw new IllegalArgumentException("Unrecognized function type: " + fcn);
    }

    public static float min(String fcn) {
        String ufcn = fcn.toUpperCase();
        if (NONE.toString().startsWith(ufcn)) {
            return 0.0f;
        }
        if (LOGISTIC.toString().startsWith(ufcn)) {
            return 0.0f;
        }
        if (LINEAR.toString().startsWith(ufcn)) {
            return Float.NEGATIVE_INFINITY;
        }
        if (TANH.toString().startsWith(ufcn)) {
            return -1.0f;
        }
        throw new IllegalArgumentException("Unrecognized function type: " + fcn);
    }

    public static TargetCompound target(String fcn, String name, int size, boolean xe) {
        String ufcn = fcn.toUpperCase();
        if (NONE.toString().startsWith(ufcn)) {
            return null;
        }
        if (LOGISTIC.toString().startsWith(ufcn)) {
            if (xe) {
                return new XEntropyTargetCompound(name, size);
            }
            return new SumOfSquaresTargetCompound(name, size);
        }
        if (LINEAR.toString().startsWith(ufcn)) {
            return new LinearTargetCompound(name, size);
        }
        if (TANH.toString().startsWith(ufcn)) {
            return new TanhTargetCompound(name, size);
        }
        throw new IllegalArgumentException("Unrecognized function type: " + fcn);
    }
}

