/*
 * Decompiled with CFR 0.152.
 */
package dmonner.xlbp.stat;

import dmonner.xlbp.stat.AbstractStat;
import dmonner.xlbp.stat.Stat;
import dmonner.xlbp.util.CSVWriter;
import java.io.IOException;
import java.util.Map;

public class BitStat
extends AbstractStat {
    public static float OFF = 0.0f;
    public static float ON = 1.0f;
    public static float MID = 0.5f;
    public static boolean WTA = false;
    private final float on;
    private final float mid;
    private final boolean wta;
    private final String name;
    private int tp;
    private int fn;
    private int fp;
    private int tn;
    private int tot;
    private int posact;
    private int posans;
    private int negact;
    private int negans;
    private int corr;
    private int incorr;
    private float acc;
    private float prec;
    private float rec;
    private float spec;
    private float f1;

    public BitStat() {
        this("");
    }

    public BitStat(BitStat that) {
        this.name = that.name;
        this.on = that.on;
        this.mid = that.mid;
        this.wta = that.wta;
        this.tp = that.tp;
        this.fn = that.fn;
        this.fp = that.fp;
        this.tn = that.tn;
        this.tot = that.tot;
        this.posact = that.posact;
        this.posans = that.posans;
        this.negact = that.negact;
        this.negans = that.negans;
        this.corr = that.corr;
        this.incorr = that.incorr;
        this.acc = that.acc;
        this.prec = that.prec;
        this.rec = that.rec;
        this.spec = that.spec;
        this.f1 = that.f1;
    }

    public BitStat(String name) {
        this.name = name;
        this.on = ON;
        this.mid = MID;
        this.wta = WTA;
    }

    public void add(BitStat that) {
        this.tp += that.tp;
        this.fn += that.fn;
        this.fp += that.fp;
        this.tn += that.tn;
    }

    public void add(int ht, int ms, int fp, int cr) {
        this.tp += ht;
        this.fn += ms;
        this.fp += fp;
        this.tn += cr;
    }

    @Override
    public void add(Stat that) {
        if (!(that instanceof BitStat)) {
            throw new IllegalArgumentException("Can only add in other BitStats.");
        }
        this.add((BitStat)that);
    }

    public void addFalseNegative() {
        ++this.fn;
    }

    public void addFalsePositive() {
        ++this.fp;
    }

    @Override
    public void addTo(String prefix, Map<String, Object> map) {
        map.put(prefix + this.name + "TP", this.tp);
        map.put(prefix + this.name + "FN", this.fn);
        map.put(prefix + this.name + "FP", this.fp);
        map.put(prefix + this.name + "TN", this.tn);
        map.put(prefix + this.name + "Correct", this.corr);
        map.put(prefix + this.name + "Incorrect", this.incorr);
        map.put(prefix + this.name + "Accuracy", Float.valueOf(this.acc));
        map.put(prefix + this.name + "Total", this.tot);
        map.put(prefix + this.name + "Precision", Float.valueOf(this.prec));
        map.put(prefix + this.name + "Recall", Float.valueOf(this.rec));
        map.put(prefix + this.name + "Specificity", Float.valueOf(this.spec));
        map.put(prefix + this.name + "F1Score", Float.valueOf(this.f1));
    }

    public void addTrueNegative() {
        ++this.tn;
    }

    public void addTruePositive() {
        ++this.tp;
    }

    @Override
    public void analyze() {
        this.corr = this.tp + this.tn;
        this.incorr = this.fp + this.fn;
        this.posact = this.tp + this.fn;
        this.negact = this.tn + this.fp;
        this.posans = this.tp + this.fp;
        this.negans = this.tn + this.fn;
        this.tot = this.corr + this.incorr;
        this.acc = this.tot == 0 ? 0.0f : (float)this.corr / (float)this.tot;
        this.prec = this.posans == 0 ? 0.0f : (float)this.tp / (float)this.posans;
        this.rec = this.posact == 0 ? 0.0f : (float)this.tp / (float)this.posact;
        this.spec = this.negact == 0 ? 0.0f : (float)this.tn / (float)this.negact;
        this.f1 = this.prec + this.rec == 0.0f ? 0.0f : 2.0f * this.prec * this.rec / (this.prec + this.rec);
    }

    private void append(StringBuilder sb, String field, float val) {
        sb.append(this.name);
        sb.append(field);
        sb.append(" = ");
        sb.append(val);
        sb.append("\n");
    }

    private void append(StringBuilder sb, String field, int val) {
        sb.append(this.name);
        sb.append(field);
        sb.append(" = ");
        sb.append(val);
        sb.append("\n");
    }

    @Override
    public void clear() {
        this.tp = 0;
        this.fn = 0;
        this.fp = 0;
        this.tn = 0;
        this.corr = 0;
        this.incorr = 0;
        this.tot = 0;
        this.acc = 0.0f;
        this.prec = 0.0f;
        this.rec = 0.0f;
        this.spec = 0.0f;
        this.f1 = 0.0f;
    }

    public void compare(float[] target, float[] output) {
        if (this.wta) {
            this.compareWTA(target, output);
        } else {
            this.compareExact(target, output);
        }
    }

    public void compareExact(float[] target, float[] output) {
        for (int i = 0; i < target.length; ++i) {
            if (Float.isInfinite(target[i]) || Float.isNaN(target[i])) {
                throw new IllegalArgumentException("Infinite/NaN Target!");
            }
            if (Float.isInfinite(output[i]) || Float.isNaN(output[i])) {
                throw new IllegalArgumentException("Infinite/NaN Output!");
            }
            if (target[i] >= this.mid) {
                if (output[i] >= this.mid) {
                    ++this.tp;
                    continue;
                }
                ++this.fn;
                continue;
            }
            if (output[i] >= this.mid) {
                ++this.fp;
                continue;
            }
            ++this.tn;
        }
    }

    public void compareWTA(float[] target, float[] output) {
        int targetIdx = -1;
        int outputIdx = -1;
        float outputMax = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < target.length; ++i) {
            if (Float.isInfinite(target[i]) || Float.isNaN(target[i])) {
                throw new IllegalArgumentException("Infinite/NaN Target!");
            }
            if (Float.isInfinite(output[i]) || Float.isNaN(output[i])) {
                throw new IllegalArgumentException("Infinite/NaN Output!");
            }
            if (target[i] == this.on) {
                if (targetIdx >= 0) {
                    throw new IllegalArgumentException("Multiple target bits set! Not suitable for WTA.");
                }
                targetIdx = i;
            }
            if (!(output[i] > outputMax)) continue;
            outputIdx = i;
            outputMax = output[i];
        }
        if (targetIdx == outputIdx) {
            ++this.tp;
            this.tn += target.length - 1;
        } else {
            ++this.fp;
            ++this.fn;
            this.tn += target.length - 2;
        }
    }

    public float getAccuracy() {
        return this.acc;
    }

    public int getActualNegatives() {
        return this.negact;
    }

    public int getActualPositives() {
        return this.posact;
    }

    public int getCorrect() {
        return this.corr;
    }

    public float getF1Score() {
        return this.f1;
    }

    public int getFalseNegatives() {
        return this.fn;
    }

    public int getFalsePositives() {
        return this.fp;
    }

    public int getIncorrect() {
        return this.incorr;
    }

    public int getNegativeAnswers() {
        return this.negans;
    }

    public int getPositiveAnswers() {
        return this.posans;
    }

    public float getPrecision() {
        return this.prec;
    }

    public float getRecall() {
        return this.rec;
    }

    public float getSensitivity() {
        return this.prec;
    }

    public float getSpecificity() {
        return this.spec;
    }

    public int getTotal() {
        return this.tot;
    }

    public int getTrueNegatives() {
        return this.tn;
    }

    public int getTruePositives() {
        return this.tp;
    }

    @Override
    public void saveData(CSVWriter out) throws IOException {
        out.appendField(this.tp);
        out.appendField(this.fn);
        out.appendField(this.fp);
        out.appendField(this.tn);
        out.appendField(this.corr);
        out.appendField(this.incorr);
        out.appendField(this.tot);
        out.appendField(this.acc);
        out.appendField(this.prec);
        out.appendField(this.rec);
        out.appendField(this.spec);
        out.appendField(this.f1);
    }

    @Override
    public void saveHeader(CSVWriter out) throws IOException {
        this.saveHeader("", out);
    }

    @Override
    public void saveHeader(String prefix, CSVWriter out) throws IOException {
        out.appendHeader(prefix + this.name + "TP");
        out.appendHeader(prefix + this.name + "FN");
        out.appendHeader(prefix + this.name + "FP");
        out.appendHeader(prefix + this.name + "TN");
        out.appendHeader(prefix + this.name + "Correct");
        out.appendHeader(prefix + this.name + "Incorrect");
        out.appendHeader(prefix + this.name + "Total");
        out.appendHeader(prefix + this.name + "Accuracy");
        out.appendHeader(prefix + this.name + "Precision");
        out.appendHeader(prefix + this.name + "Recall");
        out.appendHeader(prefix + this.name + "Specificity");
        out.appendHeader(prefix + this.name + "F1Score");
    }

    @Override
    public String toString(String prefix) {
        StringBuilder sb = new StringBuilder();
        this.append(sb, prefix + "TruePositives", this.tp);
        this.append(sb, prefix + "FalseNegatives", this.fn);
        this.append(sb, prefix + "FalsePositives", this.fp);
        this.append(sb, prefix + "TrueNegatives", this.tn);
        this.append(sb, prefix + "BitsCorrect", this.corr);
        this.append(sb, prefix + "BitsIncorrect", this.incorr);
        this.append(sb, prefix + "BitsTotal", this.tot);
        this.append(sb, prefix + "BitsAccuracy", this.acc);
        this.append(sb, prefix + "Precision", this.prec);
        this.append(sb, prefix + "Recall", this.rec);
        this.append(sb, prefix + "Specificity", this.spec);
        this.append(sb, prefix + "F1Score", this.f1);
        return sb.toString();
    }
}

